<?php
/**
 * Editor Pick Post options.
 *
 * @package New BlogBell Pro
 */

$default = sofi_blog_get_default_theme_options();
$homepage_design_layout     = sofi_blog_get_option( 'homepage_design_layout_options' );

// Blog & News Section
$wp_customize->add_section( 'section_home_editorpick',
	array(
		'title'      => __( 'Editor Pick Section', 'sofi-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_editorpick_section]',
	array(
		'default'           => $default['disable_editorpick_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sophi_blog_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Sofi_Blog_Switch_Control( $wp_customize, 'theme_options[disable_editorpick_section]',
    array(
		'label' 			=> __('Enable/Disable Editor Pick News Section', 'sofi-blog'),
		'section'    		=> 'section_home_editorpick',
		 'settings'  		=> 'theme_options[disable_editorpick_section]',
		'on_off_label' 		=> sofi_blog_switch_options(),
    )
) );

//Must Read Post Section title
$wp_customize->add_setting('theme_options[editorpick_title]', 
	array(
	'default'           => $default['editorpick_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[editorpick_title]', 
	array(
	'label'       => __('Section Title', 'sofi-blog'),
	'section'     => 'section_home_editorpick',   
	'settings'    => 'theme_options[editorpick_title]',
	'active_callback' => 'sophi_blog_editorpick_active',		
	'type'        => 'text'
	)
);


// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_content_align]', array(
	'default'           => $default['editorpick_content_align'],
	'sanitize_callback' => 'sophi_blog_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[editorpick_content_align]', array(
	'label'             => esc_html__( 'Choose Content Align', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'radio',
	'active_callback' => 'sophi_blog_editorpick_active',
	'choices'				=> array( 
		'content-right'     => esc_html__( 'Right Side', 'sofi-blog' ), 
		'content-center'     => esc_html__( 'Center Side', 'sofi-blog' ), 
		'content-left'     => esc_html__( 'Left Side', 'sofi-blog' ), 
		'content-justify'     => esc_html__( 'Justify', 'sofi-blog' )
		)
) );

// Add category enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_top_category_enable]', array(
	'default'           => $default['editorpick_top_category_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_top_category_enable]', array(
	'label'             => esc_html__( 'Enable Category of Top Post', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );	
// Add content enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_top_content_enable]', array(
	'default'           => $default['editorpick_top_content_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_top_content_enable]', array(
	'label'             => esc_html__( 'Enable Content of Top Post', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_top_posted_on_enable]', array(
	'default'           => $default['editorpick_top_posted_on_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_top_posted_on_enable]', array(
	'label'             => esc_html__( 'Enable Date of Top Post', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_top_author_enable]', array(
	'default'           => $default['editorpick_top_author_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_top_author_enable]', array(
	'label'             => esc_html__( 'Enable Author of Top Post', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );

// Number of items
$wp_customize->add_setting('theme_options[editorpick_top_excerpt_length]', 
	array(
	'default' 			=> $default['editorpick_top_excerpt_length'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sophi_blog_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[editorpick_top_excerpt_length]', 
	array(
	'label'       => __('Top Content Excerpt Length', 'sofi-blog'),
	'description' => __('Save & Refresh the customizer to see its effect. Maximum is 1000.', 'sofi-blog'),
	'section'     => 'section_home_editorpick',   
	'settings'    => 'theme_options[editorpick_top_excerpt_length]',		
	'type'        => 'number',
	'active_callback' => 'sophi_blog_editorpick_active',
	'input_attrs' => array(
			'min'	=> 0,
			'max'	=> 1000,
			'step'	=> 1,
		),
	)
);


// Additional Information First Post
//
$wp_customize->add_setting('theme_options[editorpick_top_post]', 
	array(
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sophi_blog_dropdown_pages'
	)
);

$wp_customize->add_control('theme_options[editorpick_top_post]', 
	array(
	'label'       => esc_html__('Select Post', 'sofi-blog'),
	'section'     => 'section_home_editorpick',   
	'settings'    => 'theme_options[editorpick_top_post]',		
	'type'        => 'select',
	'choices'	  => sofi_blog_post_choices(),
	'active_callback' => 'sophi_blog_editorpick_active',
	)
);

// Add category enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_category_enable]', array(
	'default'           => $default['editorpick_category_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_category_enable]', array(
	'label'             => esc_html__( 'Enable Category', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );	
// Add content enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_content_enable]', array(
	'default'           => $default['editorpick_content_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_content_enable]', array(
	'label'             => esc_html__( 'Enable Content', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_posted_on_enable]', array(
	'default'           => $default['editorpick_posted_on_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_posted_on_enable]', array(
	'label'             => esc_html__( 'Enable Date', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[editorpick_author_enable]', array(
	'default'           => $default['editorpick_author_enable'],
	'sanitize_callback' => 'sophi_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[editorpick_author_enable]', array(
	'label'             => esc_html__( 'Enable Author', 'sofi-blog' ),
	'section'           => 'section_home_editorpick',
	'type'              => 'checkbox',
	'active_callback' => 'sophi_blog_editorpick_active',
) );

// Setting  Team Category.
$wp_customize->add_setting( 'theme_options[editorpick_category]',
	array(

	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Sophi_Blog_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[editorpick_category]',
		array(
		'label'    => __( 'Select Category', 'sofi-blog' ),
		'section'  => 'section_home_editorpick',
		'settings' => 'theme_options[editorpick_category]',	
		'active_callback' => 'sophi_blog_editorpick_active',		
		)
	)
);
