<?php  
if(get_theme_mod('about_status') == true){
	$heading_text = get_theme_mod('about_heading_text');
	$walkershop_about_page = get_theme_mod( 'about_page');
	$featured_image_status = get_theme_mod('about_featured_image_status','true');
	$title_status = get_theme_mod('about_title_status','true');
	$button_status = get_theme_mod('about_cta_button_status','true');
	$button_label = get_theme_mod('about_readmore_text');
	$text_align = get_theme_mod('about_section_text_align','about-text-align-center');
	if($text_align=='about-text-align-left'){
		$text_align_class = 'text-align-left';
	}elseif($text_align =='about-text-align-right'){
		$text_align_class = 'text-align-right';
	}else{
		$text_align_class = 'text-align-center';
	}
	if(!empty($walkershop_about_page) && $walkershop_about_page != 'None' ){
		$walkerchsop_page_slug = get_page_by_path(sanitize_title($walkershop_about_page));
        if ( $walkerchsop_page_slug ) {
            $page_slug = $walkerchsop_page_slug->post_name;
            $about_id = get_page_by_path($page_slug);
            if ( $about_id ) {
                $about_page_id = $about_id->ID;
                $args = array(
                    'post_type' => 'page',
                    'page_id' =>$about_page_id
                );
            }
        }
		$walkershop_query = new WP_Query( $args );
		if ( $walkershop_query->have_posts() ) :
			while ( $walkershop_query->have_posts() ) : $walkershop_query->the_post();?>
				<div class="wrapper section-animate about-wrapper <?php echo esc_attr($text_align_class);?>">
					<div class="container">
						<?php 
								if ( has_post_thumbnail() && $featured_image_status==true ){?>
									<div class="col-md-6 img-col">
										<?php  the_post_thumbnail(); ?>
									</div>
											
								<?php }?>
						<?php if ( has_post_thumbnail() && $featured_image_status==true ){
							$about_content_class='col-md-6';
						}else{
							$about_content_class='col-md-12';
						} ?>
								<div class="text-col <?php echo esc_attr($about_content_class);?>">
									<div class="about-box">
										<?php if($title_status==true){?>
											<h5 class="page-title"><?php the_title();?></h5>
										<?php } 
										if($heading_text ==true){ ?>
											<h2 class="section-heading"><?php echo esc_html(get_theme_mod('about_heading_text'));?></h2>
										<?php } ?>
										<p class="about-description"><?php the_excerpt();?></p>

										<?php if($button_status=='true'){?>
											<a href="<?php the_permalink();?>" class="walkershop-button about-more">
												<?php 
													if(!empty($button_label)){
														echo esc_html($button_label);
													}else{
														echo __('Read More','shopcommerce');
													}
												?>
											<i class="fa-solid fa-arrow-right-long"></i> </a>
										<?php } ?>
									</div>
								</div>
								
						</div>	

					</div>
			<?php endwhile;
		endif;
		wp_reset_postdata();
	}
}