<?php
if ( ! function_exists( 'shopcommerce_setup' ) ) :
	function shopcommerce_setup() {
		add_theme_support( "title-tag");
		add_theme_support( 'automatic-feed-links' );
	}
endif;
add_action( 'after_setup_theme', 'shopcommerce_setup' );


function shopcommerce_customizer_default_settings() {
	set_theme_mod('walkershop_primary_color','#7ac198');
	set_theme_mod('offer_cta_text_color','#7ac198');
	set_theme_mod('walkershop_secondary_color','#d1b807');
	set_theme_mod('main_header_alignment_position','menu-alignment-right');
	set_theme_mod('banner_section_text_align','banner-section-text-align-center');
	set_theme_mod('footer_box_border_color','#a1e5be');
	set_theme_mod('enable_banner_ovelay_blend','');
	set_theme_mod('banenr_background_color','#000000');
	set_theme_mod('enable_latest_product_cart','');
	set_theme_mod('walkershop_body_fonts','Poppins');
	set_theme_mod('walkershop_fonts_heading_h1','Poppins');
	set_theme_mod('walkershop_fonts_heading_h2','Poppins');
	set_theme_mod('walkershop_fonts_heading_h3','Poppins');
	set_theme_mod('walkershop_fonts_heading_h4','Poppins');
	set_theme_mod('walkershop_fonts_heading_h5','Poppins');
	set_theme_mod('walkershop_fonts_heading_h6','Poppins');
	set_theme_mod('walkershop_banner_heading_typography','Poppins');
	set_theme_mod('walkershop_container_width','1600');
	set_theme_mod('latest_product_section_grid_column','walkershop-product-col-4');
	set_theme_mod('latest_product_image_height','350');
	set_theme_mod('topselling_product_section_grid_column','walkershop-product-col-2');
	set_theme_mod('topselling_product_image_height','550');
	set_theme_mod('walkershop_button_radius','0');
	set_theme_mod('banner_heading_text_size','65');
	set_theme_mod('banner_heading_text_line_height','90');
	
}
add_action( 'after_switch_theme', 'shopcommerce_customizer_default_settings' );


function shopcommerce_enqueue_styles() {
    wp_enqueue_style( 'walkershop-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'shopcommerce-style',get_stylesheet_directory_uri() . '/style.css',array('walkershop-style'));
}
add_action( 'wp_enqueue_scripts', 'shopcommerce_enqueue_styles' );

/*
* Unregister unused customizer section for theme
*/
  
	function shopcommerce_unregister_extra_section( $wp_customize ) {
		if (! walkershop_set_to_premium() ) {
	    	$wp_customize->remove_control('topselling_product_section_grid_column');
	    }
	}
	add_action( 'customize_register', 'shopcommerce_unregister_extra_section', 11 );


function shopcommerce_dynamic_style() {
    wp_enqueue_style(
        'custom-style',
        get_stylesheet_directory_uri() . '/style.css'
    );
    if ( walkershop_set_to_premium() ) {
    	$shopcommerce_footer_column_border_color = sanitize_hex_color(get_theme_mod('footer_box_border_color','#a1e5be'));
    	$shopcommerce_footer_copiright_border_color = sanitize_hex_color(get_theme_mod('footer_copyright_border_color','#a1e5be'));
    	$shopcommerce_banner_container_paddings = absint(get_theme_mod('banner_section_container_spacing'));
    	$shopcommerce_banner_container_padding= $shopcommerce_banner_container_paddings.'px';
    	$shopcommerce_banner_background_opacity = get_theme_mod('banner_background_opacity','0.58');
    	$banner_content_box_max_width = absint(get_theme_mod('banner_content_box_width','60'));
    	$shopcommerce_banner_content_box_max_width = $banner_content_box_max_width.'%';
    	$site_banner_height = absint(get_theme_mod('banner_section_height','900'));
    	$shopcommerce_banner_height = $site_banner_height.'px';
    }else{
    	$shopcommerce_footer_column_border_color ='#a1e5be';
    	$shopcommerce_footer_copiright_border_color='#a1e5be';
    	$shopcommerce_banner_container_padding ='0'.'px';
    	$shopcommerce_banner_background_opacity='0.58';
    	$shopcommerce_banner_content_box_max_width='60'.'%';
    	$shopcommerce_banner_height ='900'.'px';
    }
    $my_custom_css = "
        .footer-wiget-list.footer-colum-border-right .walkershop-footer-column{
	        border-color:$shopcommerce_footer_column_border_color !important;
	    }
	    .copyright-section{
	    	border-color:$shopcommerce_footer_copiright_border_color !important;
	    }
	     .wrapper.banner-wrapper .container.full-width{
	        padding: 0  $shopcommerce_banner_container_padding !important;
	    }
	    .wrapper.banner-wrapper .container.full-width .hero-image img{
        	opacity: $shopcommerce_banner_background_opacity !important;
        }
        span.banner-content-holder{
	        max-width:$shopcommerce_banner_content_box_max_width !important;
	    }
	    .wrapper.banner-wrapper .container.full-width .hero-image{
	        height:$shopcommerce_banner_height !important;
	    }
	";
    wp_add_inline_style( 'custom-style', $my_custom_css );
}
add_action( 'wp_enqueue_scripts', 'shopcommerce_dynamic_style' );


if(!function_exists('shopcommerce_footer_bottom_bar')){
	function shopcommerce_footer_bottom_bar(){
		if(walkershop_set_to_premium()){
			$copyright_text_align = get_theme_mod('copyright_text_alignment');
			if($copyright_text_align=='copyright-text-align-right'){
				$text_alignment_class = 'align-right';
			}elseif($copyright_text_align=='copyright-text-align-left'){
				$text_alignment_class = 'align-left';
			}else{
				$text_alignment_class ='align-center';
			}
			?>
			<div class="wrapper copyright-section <?php echo esc_attr($text_alignment_class);?>">
				<div class="container">
					<?php 
					shopcommerce_footer_copyright();
					walkershop_footer_brand_logo();
					if(get_theme_mod('footer_social_icons')==true){
						$social_icon_align = get_theme_mod('copyright_social_icon_alignment','copyright-social-align-center');
						if($social_icon_align=='copyright-social-align-left'){
							$social_icon_align_class = 'align-left';
						}elseif($social_icon_align=='copyright-social-align-right'){
							$social_icon_align_class = 'align-right';
						}else{
							$social_icon_align_class ='align-center';
						}
						echo '<div class="footer-social-media '.esc_attr($social_icon_align_class).'">';
							walkershop_social_media();
						echo '</div>';
					}
					walkershop_copyright_extra_content();
					?>
				</div><!--end of container -->
			</div><!--end of wrapper -->
	<?php } else{?>
		<div class="wrapper copyright-section align-center">
				<div class="container">
					<?php shopcommerce_footer_copyright(); ?>
				</div><!--end of container -->
			</div><!--end of wrapper -->

		<?php }

	}
}
if(!function_exists('shopcommerce_footer_copyright')){
	function shopcommerce_footer_copyright(){?>
		<div class="site-info">
			<?php
			$shopcommerce_copyright = get_theme_mod('footer_copiright_text');
			if($shopcommerce_copyright && shopcommerce_set_to_premium() ){?>
				<?php echo wp_kses_post($shopcommerce_copyright);?>
			<?php } else { ?>
				
					<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'shopcommerce' ) ); ?>">
						<?php
						/* translators: %s: CMS name, i.e. WordPress. */
						printf( esc_html__( 'Proudly powered by %s', 'shopcommerce' ), 'WordPress' );
						?>
					</a>
					<span class="sep"> | </span>
					<?php
						/* translators: 1: Theme name, 2: Theme author. */
						printf( esc_html__( 'Theme: %1$s by %2$s.', 'shopcommerce' ), 'ShopCommerce', '<a href="http://walkerwp.com/">WalkerWP</a>' );
					?>
			<?php }
			?>
		</div>
<?php }
}