<?php
/**
 * Template Name: Front Page for Theme
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package shopcommerce
 */
get_header();
walkershop_banner_section();
	if(walkershop_set_to_premium()){
		$default_order = array( 'services','latest-products','special-offer','recommended-tab','top-selling', 'top-rating', 'about-us','shopby-category', 'featured-box','featured-products','product-showcase','flash-sale','category-tabs','testimonials','disocunt-offer','latest-post','newsletter','brands-logo');
		$walkershop_sections = get_theme_mod( 'walker_charity_section_order', $default_order );
	
		if( !empty($walkershop_sections) ):
			foreach ($walkershop_sections as $section) {
				//echo $section;
				switch ( $section ) {
					case "services":
						walkershop_service_section();
					break;
					case "latest-products":
						walkershop_latest_products_section();
					break;
					case "special-offer":
						walkershop_special_offer_section();
					break;
					case "recommended-tab":
						walkershop_recommended_products_tabs();
					break;
					case "top-selling":
						walkershop_top_selling_products_section();
					break;
					case "top-rating":
						walkershop_top_rating_products_section();
					break;
					case "about-us":
						walkershop_about_us_section();
					break;
					case "shopby-category":
						walkershop_product_category_section();
					break;
					case "featured-box":
						walkershop_featured_box_section();
					break;
					case "featured-products":
						walkershop_featured_products_section();
					break;
					case "product-showcase":
						walkershop_product_showcase_section();
					break;
					case "flash-sale":
						walkershop_flash_sale_product_section();
					break;
					case "category-tabs":
						walkershop_featured_category_products_tabs();
					break;
					case "testimonials":
						walkershop_testimonial_section();
					break;
					case "disocunt-offer":
						walkershop_discount_offer_section();
					break;
					case "latest-post":
						walkershop_latest_post_section();
					break;
					case "newsletter":
						walkershop_newsletter_section();
					break;
					case "brands-logo":
						walkershop_brands_showcase_section();
					break;
				}
			}
		endif;
	}else{
		
		walkershop_latest_products_section();
		walkershop_about_us_section();
		walkershop_top_selling_products_section();
		walkershop_discount_offer_section();
		walkershop_latest_post_section();
		walkershop_service_section();
		walkershop_newsletter_section();
	}

get_footer();
