<?php
$feature_posts_id 					= get_theme_mod( 'recent_posts_category', '' );
$number_of_recent_posts_items       = get_theme_mod( 'number_of_recent_posts_items', 3 );
$recent_posts 					    = get_theme_mod( 'recent_posts', true );

$query = new WP_Query( apply_filters( 'shade_blog_recent_posts_args', array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => absint( $number_of_recent_posts_items ),
	'cat'                 => $feature_posts_id,
	'offset'              => 0,
	'ignore_sticky_posts' => 1
)));

$posts_array = $query->get_posts();

if( $recent_posts == true && is_home() ) {
	?>
	<section id="section-recent-posts">		
		<div class="col-3 clear">
			<?php
				while ( $query->have_posts() ) : $query->the_post();
				$image 	= get_the_post_thumbnail_url( get_the_ID(), 'large' ); ?>

		            <article>
		            	<div class="recent-post-item">
			            	<div class="featured-image" style="background-image: url( <?php echo esc_url( $image ); ?> );">
			            		<a href="<?php the_permalink(); ?>" class="post-thumbnail-link"></a>
							</div><!-- .featured-image -->

			            	<div class="entry-container">
					          	<header class="entry-header">
									<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
					          	</header>

					            <div class="entry-meta">
									<?php elastic_blog_posted_on() ?>
								</div><!-- .entry-meta -->
				        	</div><!-- .entry-container -->
		            	</div><!-- .recent-post-item -->
		            </article>
			        
				<?php
				endwhile; 
				wp_reset_postdata();
			?>
		</div><!-- .col-3 -->
	</section>
<?php } ?>