<?php
$editors_choice_id 					= get_theme_mod( 'editors_choice_category', '' );
$editors_choice_section_title       = get_theme_mod( 'editors_choice_section_title', 'Editors Picks' );
$number_of_editors_choice_items     = get_theme_mod( 'number_of_editors_choice_items', 3 );
$editors_choice 					= get_theme_mod( 'editors_choice', true );

$query = new WP_Query( apply_filters( 'shade_blog_editors_choice_args', array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => absint( $number_of_editors_choice_items ),
	'cat'                 => $editors_choice_id,
	'offset'              => 0,
	'ignore_sticky_posts' => 1
)));

$posts_array = $query->get_posts();

if( $editors_choice == true && is_home() ) {
	?>
	<section id="section-editors-choice">
		<div class="section-header">
			<h2 class="section-title"><?php echo esc_html($editors_choice_section_title); ?></h2>
		</div><!-- .section-header -->
		
		<div class="col-3 clear">
			<?php
				while ( $query->have_posts() ) : $query->the_post();
				$image 	= get_the_post_thumbnail_url( get_the_ID(), 'large' ); ?>

		            <article>
		            	<div class="featured-image" style="background-image: url( <?php echo esc_url( $image ); ?> );">
		            		<a href="<?php the_permalink(); ?>" class="post-thumbnail-link"></a>
						</div><!-- .featured-image -->

		            	<div class="entry-container">
				          	<header class="entry-header">
								<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
				          	</header>

				            <div class="entry-meta">
								<?php elastic_blog_posted_on() ?>
							</div><!-- .entry-meta -->
			        	</div><!-- .entry-container -->
		            </article>
			        
				<?php
				endwhile; 
				wp_reset_postdata();
			?>
		</div><!-- .col-3 -->
	</section>
<?php } ?>