<?php

// Trending Posts Section
$wp_customize->add_section('trending_posts_section', array(    
	'title'       => __('Trending Posts Section', 'shade-blog'),
	'panel'       => 'theme_option_panel'    
));

// Enable / Disable
$wp_customize->add_setting('trending_posts', 
	array(
		'default' 			=> true,
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'elastic_blog_sanitize_checkbox',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control('trending_posts', 
	array(		
		'label' 	=> __('Enable Trending Posts', 'shade-blog'),
		'section' 	=> 'trending_posts_section',
		'settings'  => 'trending_posts',
		'type' 		=> 'checkbox',
	)
);

// Section Title
$wp_customize->add_setting('trending_posts_section_title', 
	array(
		'default'           => esc_html__('Trending News', 'shade-blog'),
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('trending_posts_section_title', 
	array(
		'label'       => __('Section Title', 'shade-blog'),
		'section'     => 'trending_posts_section',   
		'settings'    => 'trending_posts_section_title',	
		'type'        => 'text'
	)
);

// Number of items
$wp_customize->add_setting('number_of_trending_posts_items', 
	array(
	'default' 			=> 9,
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'elastic_blog_sanitize_number_range'
	)
);

$wp_customize->add_control('number_of_trending_posts_items', 
	array(
	'label'       => __('Number of Items (Max: 15)', 'shade-blog'),
	'section'     => 'trending_posts_section',   
	'settings'    => 'number_of_trending_posts_items',		
	'type'        => 'number',
	'input_attrs' => array(
			'min'	=> 1,
			'max'	=> 15,
			'step'	=> 1,
		),
	)
);

// Category Dropdown
$wp_customize->add_setting('trending_posts_category', 
	array(
		'default' 			=> '',
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'elastic_blog_sanitize_select',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control('trending_posts_category', 
	array(		
		'label' 	=> __('Select Categories', 'shade-blog'),
		'section' 	=> 'trending_posts_section',
		'settings'  => 'trending_posts_category',
		'type' 		=> 'select',
		'choices' 	=> shade_blog_get_post_categories(),
	)
);