<?php

// Recent Posts Section
$wp_customize->add_section('recent_posts_section', array(    
	'title'       => __('Recent Posts Section', 'shade-blog'),
	'panel'       => 'theme_option_panel'    
));

// Enable / Disable
$wp_customize->add_setting('recent_posts', 
	array(
		'default' 			=> true,
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'elastic_blog_sanitize_checkbox',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control('recent_posts', 
	array(		
		'label' 	=> __('Enable Recent Posts', 'shade-blog'),
		'section' 	=> 'recent_posts_section',
		'settings'  => 'recent_posts',
		'type' 		=> 'checkbox',
	)
);

// Number of items
$wp_customize->add_setting('number_of_recent_posts_items', 
	array(
	'default' 			=> 3,
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'elastic_blog_sanitize_number_range'
	)
);

$wp_customize->add_control('number_of_recent_posts_items', 
	array(
	'label'       => __('Number of Items (Max: 15)', 'shade-blog'),
	'section'     => 'recent_posts_section',   
	'settings'    => 'number_of_recent_posts_items',		
	'type'        => 'number',
	'input_attrs' => array(
			'min'	=> 1,
			'max'	=> 15,
			'step'	=> 1,
		),
	)
);

// Category Dropdown
$wp_customize->add_setting('recent_posts_category', 
	array(
		'default' 			=> '',
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'elastic_blog_sanitize_select',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control('recent_posts_category', 
	array(		
		'label' 	=> __('Select Categories', 'shade-blog'),
		'section' 	=> 'recent_posts_section',
		'settings'  => 'recent_posts_category',
		'type' 		=> 'select',
		'choices' 	=> shade_blog_get_post_categories(),
	)
);