<?php

// Editors Choice Section
$wp_customize->add_section('editors_choice_section', array(    
	'title'       => __('Editors Choice Section', 'shade-blog'),
	'panel'       => 'theme_option_panel'    
));

// Enable / Disable
$wp_customize->add_setting('editors_choice', 
	array(
		'default' 			=> true,
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'elastic_blog_sanitize_checkbox',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control('editors_choice', 
	array(		
		'label' 	=> __('Enable Editors Choice', 'shade-blog'),
		'section' 	=> 'editors_choice_section',
		'settings'  => 'editors_choice',
		'type' 		=> 'checkbox',
	)
);

// Section Title
$wp_customize->add_setting('editors_choice_section_title', 
	array(
		'default'           => esc_html__('Editors Picks', 'shade-blog'),
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('editors_choice_section_title', 
	array(
		'label'       => __('Section Title', 'shade-blog'),
		'section'     => 'editors_choice_section',   
		'settings'    => 'editors_choice_section_title',	
		'type'        => 'text'
	)
);

// Number of items
$wp_customize->add_setting('number_of_editors_choice_items', 
	array(
	'default' 			=> 3,
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'elastic_blog_sanitize_number_range'
	)
);

$wp_customize->add_control('number_of_editors_choice_items', 
	array(
	'label'       => __('Number of Items (Max: 15)', 'shade-blog'),
	'section'     => 'editors_choice_section',   
	'settings'    => 'number_of_editors_choice_items',		
	'type'        => 'number',
	'input_attrs' => array(
			'min'	=> 1,
			'max'	=> 15,
			'step'	=> 1,
		),
	)
);

// Category Dropdown
$wp_customize->add_setting('editors_choice_category', 
	array(
		'default' 			=> '',
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'elastic_blog_sanitize_select',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control('editors_choice_category', 
	array(		
		'label' 	=> __('Select Categories', 'shade-blog'),
		'section' 	=> 'editors_choice_section',
		'settings'  => 'editors_choice_category',
		'type' 		=> 'select',
		'choices' 	=> shade_blog_get_post_categories(),
	)
);