<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package seos_blog
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="blog-post-item">
		<?php if ( has_post_thumbnail() and get_theme_mod( 'single_featured' ) ) : ?>
			<div class="featured-image">
				<?php seos_blog_post_thumbnail(); ?>
			</div><!-- .featured-image -->
        <?php endif; ?>

        <?php 
		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				    if( !get_theme_mod( 'posted_on' ) ) { seos_blog_posted_on(); }
					if( !get_theme_mod( 'post_author' ) ) { seos_blog_posted_by(); }
				?>
			</div><!-- .entry-meta -->			
		<?php endif; ?>

		<div class="entry-container">
	        <header class="entry-header">
				<?php
				if ( is_singular() ) :
					if( !get_theme_mod( 'post_titles' ) ) :
						the_title( '<h1 class="entry-title">', '</h1>' );
					endif;
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif; ?>
			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php the_content(); ?>
			</div><!-- .entry-content -->

			<footer class="entry-footer">
				<?php seos_blog_entry_footer(); ?>
			</footer><!-- .entry-footer -->
		</div><!-- .entry-container -->
	</div><!-- .blog-post-item -->
</article><!-- #post-<?php the_ID(); ?> -->