<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package seos_blog
 */

get_header();
?>

<div id="content-wrap" class="container">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="single-post-wrap">
				<?php
				while ( have_posts() ) :
					the_post();

					get_template_part( 'template-parts/content', 'single' );
					
					if( !get_theme_mod( 'post_navigation' ) ) :
						the_post_navigation(
							array(
								'prev_text' => '<span class="dashicons dashicons-arrow-left"></span> <span class="screen-reader-text">' . __( 'Previous Post', 'seos-blog' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . __( 'Previous', 'seos-blog' ) . '</span>',
								'next_text' => '<span class="screen-reader-text">' . __( 'Next Post', 'seos-blog' ) . '</span><span aria-hidden="true" class="nav-subtitle">' . __( 'Next', 'seos-blog' ) . '</span><span class="dashicons dashicons-arrow-right"></span>',
							)
						);
					endif;
					
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				endwhile; // End of the loop.
				?>
				</div><!-- .single-post-wrap -->
		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>

</div><!-- .container -->

<?php
get_footer();
