<?php if( ! defined( 'ABSPATH' ) ) exit;

/**
 * Sanitization callback examples.
 */
function seos_blog_sanitize_checkbox( $checked ) {
	return ( ( isset( $checked ) && true == $checked ) ? true : false );
}

/**
 * Sanitize selection
 */
if ( ! function_exists( 'seos_blog_sanitize_select' ) ) {
	function seos_blog_sanitize_select( $input, $setting ) {
		$input = sanitize_text_field( $input );
		$choices = $setting->manager->get_control( $setting->id )->choices;
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

/**
 * Sanitize number
 */
if ( ! function_exists( 'seos_blog_sanitize_number_range' ) ) {
	
	function seos_blog_sanitize_number_range( $input, $setting ) {
	
		$input = absint( $input );
		$atts = $setting->manager->get_control( $setting->id )->input_attrs;
		$min = ( isset( $atts['min'] ) ? $atts['min'] : $input );
		$max = ( isset( $atts['max'] ) ? $atts['max'] : $input );
		$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );
		return ( $min <= $input && $input <= $max && is_int( $input / $step ) ? $input : $setting->default );

	}
}
