<?php if( ! defined( 'ABSPATH' ) ) exit;

require SEOS_BLOG_THEME_DIR . 'inc/recent-post-widget/class.php';	

function seos_blog_rp_block_enqueue_script() {
    //wp_enqueue_script( 'custom-latest-posts-block-script', SEOS_BLOG_THEME_URI . 'inc/recent-post-widget/latest-posts-block.js', array( 'wp-blocks', 'wp-element' ), true );
}
add_action( 'enqueue_block_editor_assets', 'seos_blog_rp_block_enqueue_script' );

function seos_blog_rp_enqueue_script() {
    wp_enqueue_style( 'seos-blog-rp-widgets', SEOS_BLOG_THEME_URI . 'inc/recent-post-widget/style.css', false, SEOS_BLOG_THEME_VERSION );
}
add_action( 'wp_enqueue_scripts', 'seos_blog_rp_enqueue_script' );


function seos_blog_posts_block_render( $instance ) {
    $number_of_posts = ! empty( $instance['number_of_posts'] ) ? $instance['number_of_posts'] : 5;
    $hide_date = isset( $instance['hide_date'] ) ? $instance['hide_date'] : false;
    $hide_excerpt = isset( $instance['hide_excerpt'] ) ? $instance['hide_excerpt'] : false;
    $posts_query = new WP_Query( array(
        'posts_per_page' => $number_of_posts,
        'post_status' => 'publish',
    ) );

    if ( $posts_query->have_posts() ) {
        $output = '<div class="seos-rp-widget">';

        while ( $posts_query->have_posts() ) {
            $posts_query->the_post();
			
			$excerpt = get_the_excerpt();
		 
			
			
			if( $hide_date != 1){
			    $date = '<div class="rp-date"><span class="dashicons dashicons-calendar"></span> <em class="rp-date-right">' . get_the_date() . '</em></div>';
			} else {
			    $date = '';
			}			
			
			if( $hide_excerpt != 1){
			    $excerpt = wp_trim_words( $excerpt, 10, '...' );
			} else {
			    $excerpt = '';
			}
			
            $output .= '<div class="rp-posts">';
            if ( has_post_thumbnail() ) {
                $output .= '<a class="rp-left" href="' . get_permalink() . '">' . get_the_post_thumbnail() . '</a>';
            }
			$output .= '<a class="rp-url"   href="' . get_permalink() . '">' . get_the_title() . '</a>';
			$output .= '<p>' . $excerpt . '</p>';
			$output .= $date;
            $output .= '</div>';
        }

        $output .= '</div>';

        wp_reset_postdata();

        return $output;
    } else {
        return '<p>No posts found</p>';
    }
}

function seos_blog_latest_posts_widget() {
    register_widget( 'SEOS_Latest_Posts_Widget' );
}
add_action( 'widgets_init', 'seos_blog_latest_posts_widget' );





