<?php if( ! defined( 'ABSPATH' ) ) exit;
	
class SEOS_Latest_Posts_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(
            'sbrw',
            __( 'Latest Posts With Featured Image', 'seos-blog' ),
            array( 'description' => __( 'A widget that displays the latest posts with featured image.', 'seos-blog' ), ) // Описание на виджета
        );
    }

    public function form( $instance ) {

        if ( isset( $instance[ 'number_of_posts' ] ) ) {
            $number_of_posts = $instance[ 'number_of_posts' ];
        }
        else {
            $number_of_posts = 5;
        }
		$hide_date = isset( $instance['hide_date'] ) ? $instance['hide_date'] : false;
		$hide_excerpt = isset( $instance['hide_excerpt'] ) ? $instance['hide_excerpt'] : false;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'number_of_posts' ); ?>"><?php _e( 'Number of posts to show:', 'seos-blog' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'number_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'number_of_posts' ); ?>" min="1" type="number" value="<?php echo esc_attr( $number_of_posts ); ?>" />
        </p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo $this->get_field_id( 'hide_date' ); ?>" name="<?php echo $this->get_field_name( 'hide_date' ); ?>" value="1" <?php checked( $hide_date, 1 ); ?> /> 
			<label for="<?php echo $this->get_field_id( 'hide_date' ); ?>"><?php _e( 'Hide Date', 'seos-blog' ); ?></label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" id="<?php echo $this->get_field_id( 'hide_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'hide_excerpt' ); ?>" value="1" <?php checked( $hide_excerpt, 1 ); ?> /> 
			<label for="<?php echo $this->get_field_id( 'hide_excerpt' ); ?>"><?php _e( 'Hide Excerpt', 'seos-blog' ); ?></label>
		</p>		
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['number_of_posts'] = ( ! empty( $new_instance['number_of_posts'] ) ) ? strip_tags( $new_instance['number_of_posts'] ) : 5;
        $instance['hide_date'] = ( ! empty( $new_instance['hide_date'] ) ) ? strip_tags( $new_instance['hide_date'] ) : 0;
        $instance['hide_excerpt'] = ( ! empty( $new_instance['hide_excerpt'] ) ) ? strip_tags( $new_instance['hide_excerpt'] ) : 0;
        return $instance;
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        echo seos_blog_posts_block_render( $instance );
        echo $args['after_widget'];
    }
}


