<?php if( ! defined( 'ABSPATH' ) ) exit;
	
function calculate_reading_time( $content ) {
    $word_count = str_word_count( strip_tags( $content ) );
    $reading_speed = 225;
    $time_in_minutes = ceil( $word_count / $reading_speed );
    return $time_in_minutes;
}
/**
 * Enqueue scripts and styles.
 */
function seos_blog_recent_post_slider_scripts() {
	wp_enqueue_script( 'options-slick-js', SEOS_BLOG_THEME_URI . 'inc/recent-post-slider/options.js', array( 'jquery' ), SEOS_BLOG_THEME_VERSION, true );

	wp_enqueue_script( 'slick-js', SEOS_BLOG_THEME_URI . 'inc/recent-post-slider/slick.js', array(), SEOS_BLOG_THEME_VERSION, false );
	wp_enqueue_style( 'slick-css', SEOS_BLOG_THEME_URI . 'inc/recent-post-slider/slick.css', false, SEOS_BLOG_THEME_VERSION );

	// Localize the script with new data
    $array = array(
        'speed' => get_theme_mod('seos_blog_recent_post_speed' )
    );
    wp_localize_script( 'options-slick-js', 'objects', $array );
	
}
add_action( 'wp_enqueue_scripts', 'seos_blog_recent_post_slider_scripts' );


function seos_blog_recent_post_slider() { ?>

<div class="container-slider">
	<?php if( get_theme_mod( 'seos_blog_recent_post_title' ) ) { ?>
		<h4 class="sca-slider-title"><?php echo esc_html( get_theme_mod('seos_blog_recent_post_title' ) ); ?></h4>
		<div class="border1"></div>
	<?php } ?>		
		<div class="autoplay1">	
<?php

/* Get all sticky posts */
$sticky = get_option( 'sticky_posts' );
 
/* Sort the stickies with the newest ones at the top */
rsort( $sticky );
 
/* Get the 5 newest stickies (change 5 for a different number) */
$sticky = array_slice( $sticky, 0, 50 );
 
/* Query sticky posts */
if ( get_theme_mod( 'seos_blog_recent_post_activate' ) == "sticky" ) {
    $the_query = new WP_Query( array( 'post__in' => $sticky, 'ignore_sticky_posts' => 1, 'posts_per_page' => 50 ) );
}
elseif ( get_theme_mod( 'seos_blog_recent_post_activate', 'all' ) == "all" ) {
    $the_query = new WP_Query( array(  'ignore_sticky_posts' => 1, 'posts_per_page' => 50 ) );	
}

if( get_theme_mod( 'seos_blog_recent_post_activate', 'all' ) ) {
// The Loop
if ( $the_query->have_posts() ) { ?>
  
    <?php while ( $the_query->have_posts() ) {
        $the_query->the_post(); ?>
		
		<div class="sca-slide">
			<?php if( get_theme_mod( 'seos_blog_recent_post_vote' ) ) { ?>
			    <div class="hide-vote"><?php echo seos_blog_single (); ?></div>
			<?php } ?>
			
			<?php if( get_theme_mod( 'read_time' ) ) {						
				$content = get_post_field( 'post_content', get_the_ID() );
				$reading_time = calculate_reading_time( esc_html( $content ) );
				echo '<div class="r-time"><span class="dashicons dashicons-clock"></span> ' . $reading_time . ' <em>min</em></div>';
			}
			
			global $post; ?>
			<?php if ( has_post_thumbnail() ) { 
			?>      <a href="<?php echo esc_url(get_permalink()); ?>"> <?php
						the_post_thumbnail( 'custom-size' );
					?></a> <?php
					} 
					else {
						?>
						<a href="<?php echo esc_url(get_permalink()); ?>"><img src="<?php echo esc_url( SEOS_BLOG_THEME_URI ); ?>assets/images/no-sticky.jpg"/></a>
						<?php } ?>
						<h3><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html( get_the_title() ); ?></a></h3>
						
						<div class="score-border"></div>
						<div class="foo-detiles">
						    <?php if( !get_theme_mod( 'seos_blog_recent_post_date' ) ) { echo '<span class="dashicons dashicons-calendar"></span> '.esc_html( get_the_date() ); } ?> 
						    <?php if( !get_theme_mod( 'seos_blog_recent_post_author' ) ) { echo ' / <span class="dashicons dashicons-admin-users"></span> '.esc_html( get_the_author() ); } ?>
						</div>
		</div>
					<?php
					

	
					
					
    }
}
/* Restore original Post Data */
wp_reset_postdata();
}
//return $return; 
?>
	</div>

</div>

<?php }


	
function seos_blog_recent_post_customize_register( $wp_customize ) {

/***********************************************************************************/

		function seos_blog_sanitize_recent_post( $input ) {
			$valid = array(
  			    'all' => esc_attr__( 'Show All Posts', 'seos-blog' ),
				'sticky' => esc_attr__( 'Show Only Sticky Posts', 'seos-blog' ),
			);

			if ( array_key_exists( $input, $valid ) ) {
				return $input;
			} else {
				return '';
			}
		}

		$wp_customize->selective_refresh->add_partial( 'seos_blog_recent_post_activate', array(
			'selector' => '.sca-slide',
			'render_callback' => 'seos_blog_customize_partial_seos_blog_recent_post_activate',
		) );
		
		$wp_customize->selective_refresh->add_partial( 'seos_blog_recent_post_title', array(
			'selector' => '.sca-slider-title',
			'render_callback' => 'seos_blog_customize_partial_seos_blog_recent_post_title',
		) );			
/***************** Slider General *********************/
		
		$wp_customize->add_section( 'seos_blog_recent_post_options' , array(
			'title'       => __( 'Recent Posts Slider', 'seos-blog' ),
			'priority'   => 1,
		) );
						
		$wp_customize->add_setting( 'seos_blog_recent_post_activate', array (
			'sanitize_callback' => 'seos_blog_sanitize_recent_post',
			'default' => 'all',
		) );
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog_recent_post_activate', array(
			'label'    => __( 'Recent Posts Slider', 'seos-blog' ),
			'section'  => 'seos_blog_recent_post_options',		
			'type'     =>  'select',		
            'choices'  => array(
  			    'all' => esc_attr__( 'Show All Posts', 'seos-blog' ),
				'sticky' => esc_attr__( 'Show Only Sticky Posts', 'seos-blog' ),
            )
		) ) );
		
		$wp_customize->add_setting( 'seos_blog_recent_post_home_header', array (
			'sanitize_callback' => 'seos_blog_sanitize_checkbox',
			'default' => false,
		) );
		
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog_recent_post_home_header', array(
			'label'    => __( 'Activate on Homepage Header', 'seos-blog' ),
			'section'  => 'seos_blog_recent_post_options',
			'settings' => 'seos_blog_recent_post_home_header',
			'type' => 'checkbox',
		) ) );
		
		$wp_customize->add_setting( 'seos_blog_recent_post_home', array (
			'sanitize_callback' => 'seos_blog_sanitize_checkbox',
		) );
		
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog_recent_post_home', array(
			'label'    => __( 'Activate on Homepage Footer', 'seos-blog' ),
			'section'  => 'seos_blog_recent_post_options',
			'settings' => 'seos_blog_recent_post_home',
			'type' => 'checkbox',
		) ) );
		
		$wp_customize->add_setting( 'seos_blog_recent_post_title', array (
			'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'seos_blog_recent_post_title', array(
			'label'    => __( 'Section Title', 'seos-blog' ),		
			'section'  => 'seos_blog_recent_post_options',
			'settings' => 'seos_blog_recent_post_title',
			'type'     =>  'text'				
		) ) );	
		
		$wp_customize->add_setting( 'seos_blog_recent_post_speed', array (
			'sanitize_callback' => 'absint',
		) );
		
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog_recent_post_speed', array(
			'label'    => __( 'Slider Speed in milliseconds', 'seos-blog' ),
			'section'  => 'seos_blog_recent_post_options',
			'settings' => 'seos_blog_recent_post_speed',
			'type' => 'number',
			'input_attrs' => array(
				'min' => '1000',
				'step' => '100',
				'max' => '20000',
			),			
	) ) );		

	$wp_customize->add_setting( 'read_time', array (
		'sanitize_callback' => 'seos_blog_sanitize_checkbox',
		'default' => false,
	) );
		
		
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'read_time', array(
		'label'    => __( 'Activate Read Time', 'seos-blog' ),
		'section'  => 'seos_blog_recent_post_options',
		'type' => 'checkbox',
	) ) );

	
	$wp_customize->add_setting( 'seos_blog_recent_post_date', array (
		'sanitize_callback' => 'seos_blog_sanitize_checkbox',
	) );
		
		
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog_recent_post_date', array(
		'label'    => __( 'Deactivate Date', 'seos-blog' ),
		'section'  => 'seos_blog_recent_post_options',
		'type' => 'checkbox',
	) ) );
	
	$wp_customize->add_setting( 'seos_blog_recent_post_author', array (
		'sanitize_callback' => 'seos_blog_sanitize_checkbox',
	) );
		
		
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog_recent_post_author', array(
		'label'    => __( 'Deactivate Author', 'seos-blog' ),
		'section'  => 'seos_blog_recent_post_options',
		'type' => 'checkbox',
	) ) );	
	
}
add_action( 'customize_register', 'seos_blog_recent_post_customize_register' );