<?php if( ! defined( 'ABSPATH' ) ) exit;
/**
 * Read More Button
 */
if ( ! function_exists( 'seos_blog_excerpt_length' ) ) :


  function seos_blog_excerpt_length( $length ) {

    if ( is_admin() ) {
      return $length;
    }

    $excerpt_length = get_theme_mod( 'excerpt_length', 28 );

    if ( absint( $excerpt_length ) > 0 ) {
      $length = absint( $excerpt_length );
    }

    return $length;
  }

endif;

add_filter( 'excerpt_length', 'seos_blog_excerpt_length', 999 );


	function seos_blog_excerpt_more( $more ) {
		if ( is_admin() ) {
			return $more;
		}
        return '<p class="link-more"><a class="rm-button" href="'. esc_url(get_permalink( get_the_ID() ) ) . '">' . seos_blog_return_read_more_text (). '</a></p>';
	}
	add_filter( 'excerpt_more', 'seos_blog_excerpt_more' );


	function seos_blog_return_read_more_text () {
		if( get_theme_mod( 'read_more_text', 'Read More' ) ) {
			return esc_html( get_theme_mod( 'read_more_text', 'Read More' ) );
		} else {
		return;
		}
	}