<?php if( ! defined( 'ABSPATH' ) ) exit;
/**
 * Theme Options.
 *
 * @package seos_blog
 */

// Add Panel.
$wp_customize->add_panel( 'theme_option_panel',
	array(
	'title'      => __( 'Theme Options', 'seos-blog' ),
	'priority'   => 8,
	)
);

$wp_customize->add_section('section_blog_page', array(    
	'title'       => __('Page Options', 'seos-blog'),
	'panel'       => 'theme_option_panel'    
));

$wp_customize->add_setting('blog_column', 
	array(
	'default' 			=> '1',
	'sanitize_callback' => 'seos_blog_sanitize_select',
	)
);

$wp_customize->add_control('blog_column', 
	array(		
	'label' 	=> __('Archive Page Column', 'seos-blog'),
	'section' 	=> 'section_blog_page',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'1' 	=> __( '3 Column', 'seos-blog'),						
		'2'     => __( '2 Column', 'seos-blog'),	
		'3' 	=> __( '1 Column', 'seos-blog'),	
		),	
	)
);

$wp_customize->add_setting( 'header_thumbnail', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'header_thumbnail', array(
	'label'    => __( 'Activate Single Page Featured Header Image', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'single_featured', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'single_featured', array(
	'label'    => __( 'Activate Single Post Featured Image', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'single_page_featured', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'single_page_featured', array(
	'label'    => __( 'Activate Single Page Featured Image', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'page_titles', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'page_titles', array(
	'label'    => __( 'Deactivate Single Page Titles', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'post_titles', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'post_titles', array(
	'label'    => __( 'Deactivate Single Post Titles', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'post_navigation', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'post_navigation', array(
	'label'    => __( 'Deactivate Single Post Navigation', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'widgets_icons', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'widgets_icons', array(
	'label'    => __( 'Deactivate Widget Icons', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'post_author', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'post_author', array(
	'label'    => __( 'Deactivate Posted By', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'posted_on', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'posted_on', array(
	'label'    => __( 'Deactivate Posted On', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'posted_in', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'posted_in', array(
	'label'    => __( 'Deactivate Posted In Categories', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

$wp_customize->add_setting( 'tags_links', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tags_links', array(
	'label'    => __( 'Deactivate Tags Links', 'seos-blog' ),
	'section'  => 'section_blog_page',
	'type' => 'checkbox',
) ) );

// Sidebar section
$wp_customize->add_section('section_sidebar', array(    
	'title'       => __('Sidebar Options', 'seos-blog'),
	'panel'       => 'theme_option_panel'    
));

// Blog Sidebar Option
$wp_customize->add_setting('blog_sidebar', 
	array(
	'default' 			=> 'no-sidebar',
	'sanitize_callback' => 'seos_blog_sanitize_select',
	)
);

$wp_customize->add_control('blog_sidebar', 
	array(		
	'label' 	=> __('Blog Sidebar', 'seos-blog'),
	'section' 	=> 'section_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'seos-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'seos-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'seos-blog'),	
		),	
	)
);

// Single Post Sidebar Option
$wp_customize->add_setting('single_post_sidebar', 
	array(
	'default' 			=> 'right-sidebar',
	'sanitize_callback' => 'seos_blog_sanitize_select',
	)
);

$wp_customize->add_control('single_post_sidebar', 
	array(		
	'label' 	=> __('Single Post Sidebar', 'seos-blog'),
	'section' 	=> 'section_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'seos-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'seos-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'seos-blog'),	
		),	
	)
);

// Archive Sidebar Option
$wp_customize->add_setting('archive_sidebar', 
	array(
	'default' 			=> 'no-sidebar',
	'sanitize_callback' => 'seos_blog_sanitize_select',
	)
);

$wp_customize->add_control('archive_sidebar', 
	array(		
	'label' 	=> __('Archive Sidebar', 'seos-blog'),
	'section' 	=> 'section_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'seos-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'seos-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'seos-blog'),	
		),	
	)
);

// Page Sidebar Option
$wp_customize->add_setting('page_sidebar', 
	array(
	'default' 			=> 'no-sidebar',
	'sanitize_callback' => 'seos_blog_sanitize_select',
	)
);

$wp_customize->add_control('page_sidebar', 
	array(		
	'label' 	=> __('Page Sidebar', 'seos-blog'),
	'section' 	=> 'section_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'seos-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'seos-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'seos-blog'),	
		),	
	)
);

// Read More
$wp_customize->add_section('read_more', 
	array(    
	'title'       => __('Read More', 'seos-blog'),
	'panel'       => 'theme_option_panel'    
	)
);

$wp_customize->add_setting( 'excerpt_length', array(
	'default'           => '30',
	'sanitize_callback' => 'seos_blog_sanitize_number_range',
) );

$wp_customize->add_control( 'excerpt_length', array(
	'label'       => __( 'Excerpt Length', 'seos-blog' ),
	'description' => __( 'Min 10 - Max 100.', 'seos-blog' ),
	'section'     => 'read_more',
	'type'        => 'number',
	'input_attrs' => array( 'min' => 10, 'max' => 100, 'style' => 'width: 55px;' ),
) );

$wp_customize->add_setting( 'read_more_text', array (
	'sanitize_callback' => 'sanitize_text_field',
	'default' => 'Read More',
) );
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'read_more_text', array(
	'priority'    => 1,
	'label'    => __( 'Read More Text', 'seos-blog' ),
	'section'  => 'read_more',
	'type' => 'text',
) ) );


// Header Image Zoom
$wp_customize->add_setting( 'seos_blog__header_zoom', array (		
	'sanitize_callback' => 'seos_blog_sanitize_checkbox',
) );
		
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'seos_blog__header_zoom', array(
	'label'    => __( 'Dectivate Image Zoom:', 'seos-blog' ),
	'section'  => 'header_image',
		'priority'    => 1,
	'type' => 'checkbox',
) ) );