<?php if( ! defined( 'ABSPATH' ) ) exit;
/**
 * SEOS Blog Theme Customizer
 *
 * @package seos_blog
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function seos_blog_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	// Load sanitize functions.
	include SEOS_BLOG_THEME_DIR . 'inc/sanitize.php';
	include SEOS_BLOG_THEME_DIR . 'inc/customizer/theme-options.php';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'seos_blog_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'seos_blog_customize_partial_blogdescription',
		) );
	}

}
add_action( 'customize_register', 'seos_blog_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function seos_blog_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function seos_blog_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function seos_blog_customize_preview_js() {
	wp_enqueue_script( 'seos-blog-customizer', SEOS_BLOG_THEME_URI . 'assets/js/customizer.js', array( 'customize-preview' ), SEOS_BLOG_THEME_VERSION, true );
}
add_action( 'customize_preview_init', 'seos_blog_customize_preview_js' );

/**
 * Customizer control scripts and styles.
 *
 * @since 1.0.0
 */
function seos_blog_customizer_control_scripts() {

	wp_enqueue_style( 'seos-blog-customize-controls', SEOS_BLOG_THEME_URI . 'assets/css/customize.css', '', SEOS_BLOG_THEME_VERSION );

	wp_enqueue_script( 'seos-blog-customize-controls', SEOS_BLOG_THEME_URI . 'assets/js/customize-controls.js', array( 'customize-controls' ), SEOS_BLOG_THEME_VERSION, true );
}
add_action( 'customize_controls_enqueue_scripts', 'seos_blog_customizer_control_scripts', 0 );
