<?php
// Do not allow direct access to the file.
if( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Header Top
 *
 */
function seos_blog_header () {
	if ( get_theme_mod( 'activate_header_top', false ) ) :	
	$email = get_theme_mod('header_email', 'email@site.com' );
	$address = get_theme_mod( 'header_address', 'Str. Name 1' );
	$phone = get_theme_mod( 'header_phone', '+012 345 678' );
	?>
	 
		<div class="header-top">
		 
				<?php if ( $email ) { ?>
					<div class="h-email" itemprop="email"><a href="mailto:<?php echo esc_html( $email ); ?>"><span class="dashicons dashicons-email-alt"> </span> <?php echo esc_html( $email ); ?></a></div>
				<?php } ?>
				<?php if ( $address ) { ?>
					<div class="h-address" itemprop="address" itemscope itemtype="http://schema.org/PostalAddress"><span class="dashicons dashicons-location"></span><?php echo esc_html( $address ); ?></div>
				<?php } ?>
				<?php if ( $phone ) { ?>
					<div class="h-phone" itemprop="telephone"><a href="tel:<?php echo esc_html( $phone ); ?>"><span class="dashicons dashicons-phone"> </span> <?php echo esc_html( $phone ); ?></a></div>
				<?php } ?>
				
				<div id="live-time">
				<?php if ( !get_theme_mod( 'activate_header_date' ) ) { ?>	
					<span class="dashicons dashicons-calendar-alt"> </span> 
					<span id="live-date"><?php echo esc_html( date_i18n('F d, Y', false) ); ?></span>
				<?php } ?>
				<?php if ( !get_theme_mod( 'activate_header_clock' ) ) { ?>	
					<div id="live-clock">
						<div id="live-time">
							<span id="live-hours"><?php esc_html_e('11', 'seos-blog'); ?></span>
							<span id="live-minutes"><?php esc_html_e('11', 'seos-blog'); ?></span>
							<span id="live-seconds"><?php esc_html_e('11', 'seos-blog'); ?></span>
							<span id="live-phase"><?php esc_html_e('AM', 'seos-blog'); ?></span>
						</div>
					</div>
				<?php } ?>
				</div>
				
				<?php  
				if ( get_theme_mod( 'seos_blog_active_social' ) ) { seos_blog_social_section (); } ?>	
		</div>
		<?php
	endif;
}



add_action( 'customize_register', 'seos_blog_header_top_customize_register' );

function seos_blog_header_top_customize_register( $wp_customize ) {
	
/***********************************************************************************
 * Back to top button Options
***********************************************************************************/
 
		$wp_customize->add_section( 'header_top' , array(
			'title'       => __( 'Header Top', 'seos-blog' ),
			'priority'   => 2,
		) );
		
		$wp_customize->add_setting( 'activate_header_top', array (
			'sanitize_callback' => 'seos_blog_sanitize_checkbox',
			'default' => false
		) );
		
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'activate_header_top', array(
			'priority'    => 1,
			'label'    => __( 'Activate Header Top', 'seos-blog' ),
			'section'  => 'header_top',
			'settings' => 'activate_header_top',
			'type' => 'checkbox',
		) ) );
		
 	    $wp_customize->add_setting( 'header_email', array (
			'sanitize_callback' => 'sanitize_text_field',
			'default' => 'email@example.com'
		) );
			
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'header_email', array(
			'label'    => __( 'E-mail', 'seos-blog' ),
			'priority'    => 3,
			'section'  => 'header_top',
			'type' => 'text',
		) ) );

 	    $wp_customize->add_setting( 'header_address', array (
			'sanitize_callback' => 'sanitize_text_field',
			'default' => 'Str. Name 1'
		) );
			
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'header_address', array(
			'label'    => __( 'Address', 'seos-blog' ),
			'priority'    => 3,
			'section'  => 'header_top',
			'settings' => 'header_address',
			'type' => 'text',
		) ) );

 	    $wp_customize->add_setting( 'header_phone', array (
			'sanitize_callback' => 'sanitize_text_field',
			'default' => '+012 345 678'
		) );
			
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'header_phone', array(
			'label'    => __( 'Phone', 'seos-blog' ),
			'priority'    => 3,
			'section'  => 'header_top',
			'settings' => 'header_phone',
			'type' => 'text',
		) ) );
		
		$wp_customize->add_setting( 'activate_header_clock', array (
			'sanitize_callback' => 'seos_blog_sanitize_checkbox',
		) );
		
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'activate_header_clock', array(
			'priority'    => 3,
			'label'    => __( 'Deactivate Header Clock', 'seos-blog' ),
			'section'  => 'header_top',
			'settings' => 'activate_header_clock',
			'type' => 'checkbox',
		) ) );		
				
		$wp_customize->add_setting( 'activate_header_date', array (
			'sanitize_callback' => 'seos_blog_sanitize_checkbox',
		) );
		
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'activate_header_date', array(
			'priority'    => 3,
			'label'    => __( 'Deactivate Header Date', 'seos-blog' ),
			'section'  => 'header_top',
			'settings' => 'activate_header_date',
			'type' => 'checkbox',
		) ) );
		

		
}


