<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package seos_blog
 */

?>
<!DOCTYPE html>
<html itemscope itemtype="http://schema.org/WebPage" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'seos-blog' ); ?></a>
<?php echo seos_blog_header (); ?>
	<?php if ( is_singular() && has_post_thumbnail() && get_theme_mod('header_thumbnail') ) : ?>
		<div class="custom-header">
			<div class="custom-header-media">
				<div id="wp-custom-header" class="wp-custom-header">
					<img class="header-image"  style="<?php seos_blog__heade_image_zoom_speed(); ?>" src="<?php echo esc_url( the_post_thumbnail_url() ); ?>" alt="Header Image" 
					srcset="<?php echo the_post_thumbnail_url(); ?> 1000w, <?php echo esc_url( the_post_thumbnail_url() ); ?>, 
					<?php echo esc_url( the_post_thumbnail_url() ); ?> 300w, <?php echo esc_url( the_post_thumbnail_url() ); ?> 768w" 
					sizes="(max-width: 1000px) 100vw, 1000px" decoding="async" fetchpriority="high">
				</div>
			</div>
		</div>
	<?php 
		elseif( ( is_front_page() || !is_paged() ) and has_header_image() ) : ?>
		<div class="custom-header">
			<div class="custom-header-media">
				<div id="wp-custom-header" class="wp-custom-header">
					<img class="header-image" style="<?php seos_blog__heade_image_zoom_speed(); ?>" src="<?php echo esc_url( get_header_image() ); ?>" alt="Header Image" 
					srcset="<?php echo get_header_image(); ?> 1000w, <?php echo esc_url( get_header_image() ); ?>, 
					<?php echo esc_url( get_header_image() ); ?> 300w, <?php echo esc_url( get_header_image() ); ?> 768w" 
					sizes="(max-width: 1000px) 100vw, 1000px" decoding="async" fetchpriority="high">
				</div>
			</div>
		</div>		
	<?php endif; ?>
	
	<header id="masthead" class="site-header" itemscope="itemscope" itemtype="http://schema.org/WPHeader">
	<?php 
	if (  display_header_text() || has_custom_logo() ) {
	?>	
		<div class="site-branding">
			<div class="container">
				<div class="site-branding-logo" itemprop="logo" itemscope="itemscope" itemtype="http://schema.org/Brand">
					<?php the_custom_logo(); ?>
				</div><!-- .site-branding-logo -->

				<div class="site-branding-text">
					<?php if ( is_front_page() ) : ?>
						<h1 class="site-title" itemscope itemtype="http://schema.org/Brand"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					<?php else : ?>
						<p class="site-title" itemscope itemtype="http://schema.org/Brand"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
					<?php endif; ?>

					<?php
					$description = get_bloginfo( 'description', 'display' );

					if ( $description || is_customize_preview() ) :
						?>
						<p class="site-description" itemprop="headline"><?php echo esc_html( $description ); ?></p>
					<?php endif; ?>
				</div><!-- .site-branding-text -->
			</div><!-- .container -->
		</div><!-- .site-branding -->
	<?php } ?>
		<nav id="site-navigation" class="main-navigation navigation-menu">
			<div class="container">
				<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
					<div class="nav-right visible-xs">
						<div class="button" id="btn">
							<div class="bar top"></div>
							<div class="bar middle"></div>
							<div class="bar bottom"></div>
						</div>
					</div>
				</button>
				<?php
					if ( has_nav_menu( 'primary_menu' ) ) {
						wp_nav_menu( array(
							'theme_location' => 'primary_menu',
							'container'      => false,
							'menu_id'        => 'primary-menu',
							'menu_class'     => 'nav-menu',
						) );
					} else {
						wp_nav_menu( array(
							'theme_location' => '',
							'container'      => false,
							'menu_id'        => 'default-menu',
							'menu_class'     => 'nav-menu',
						) );
					}
				?>
			</div><!-- .container -->
		</nav><!-- #site-navigation -->

	</header><!-- #masthead -->

	<div id="content" class="site-content">	<?php
		if ( (is_front_page() or is_home() ) and get_theme_mod( 'seos_blog_recent_post_home_header') ) {
			echo seos_blog_recent_post_slider();	
		}
	?>