<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package seos_blog
 */

define( 'SEOS_BLOG_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
define( 'SEOS_BLOG_THEME_DIR', trailingslashit( get_template_directory() ) );

$seos_blog_theme = wp_get_theme();
$seos_blog_theme_version = $seos_blog_theme->get( 'Version' );
define( 'SEOS_BLOG_THEME_VERSION', $seos_blog_theme_version );

if ( ! function_exists( 'seos_blog_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function seos_blog_setup() {
		/*
		 * Make theme available for translation.
		 */
		load_theme_textdomain( 'seos-blog', SEOS_BLOG_THEME_DIR . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
        /*
         * WooCommerce Support
         */
		if ( class_exists( 'WooCommerce' ) ) {
			add_theme_support( 'woocommerce' );
			add_theme_support( 'wc-product-gallery-zoom' );
			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );
		}
		
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-styles' );
		add_theme_support( 'wp-block-styles' );
        add_theme_support( 'custom-line-height' );
        add_theme_support( 'responsive-embeds' );
		
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary_menu' 		=> esc_html__( 'Primary Menu', 'seos-blog' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'seos_blog_custom_background_args', array(
			'default-color' => 'f8f8f8',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		/*
		* This theme styles the visual editor to resemble the theme style,
		* specifically font, colors, icons, and column width.
		*/
		add_editor_style( array( '/assets/css/editor-style.css', seos_blog_get_fonts_url() ) );

		// Gutenberg support
		add_theme_support( 'editor-color-palette', array(
	       	array(
				'name' => esc_html__( 'Blue', 'seos-blog' ),
				'slug' => 'blue',
				'color' => '#2c7dfa',
	       	),
			array(
				'name' => esc_html__( 'Red', 'seos-blog' ),
				'slug' => 'red',
				'color' => 'red',
	       	),
	       	array(
	           	'name' => esc_html__( 'Green', 'seos-blog' ),
	           	'slug' => 'green',
	           	'color' => '#07d79c',
	       	),
	       	array(
	           	'name' => esc_html__( 'Orange', 'seos-blog' ),
	           	'slug' => 'orange',
	           	'color' => '#ff8737',
	       	),
	       	array(
	           	'name' => esc_html__( 'Black', 'seos-blog' ),
	           	'slug' => 'black',
	           	'color' => '#2f3633',
	       	),
	       	array(
	           	'name' => esc_html__( 'Grey', 'seos-blog' ),
	           	'slug' => 'grey',
	           	'color' => '#82868b',
	       	),
	   	));

		
		add_theme_support( 'editor-font-sizes', array(
		   	array(
		       	'name' => esc_html__( 'small', 'seos-blog' ),
		       	'shortName' => esc_html__( 'S', 'seos-blog' ),
		       	'size' => 12,
		       	'slug' => 'small'
		   	),
		   	array(
		       	'name' => esc_html__( 'regular', 'seos-blog' ),
		       	'shortName' => esc_html__( 'M', 'seos-blog' ),
		       	'size' => 16,
		       	'slug' => 'regular'
		   	),
		   	array(
		       	'name' => esc_html__( 'larger', 'seos-blog' ),
		       	'shortName' => esc_html__( 'L', 'seos-blog' ),
		       	'size' => 36,
		       	'slug' => 'larger'
		   	),
		   	array(
		       	'name' => esc_html__( 'huge', 'seos-blog' ),
		       	'shortName' => esc_html__( 'XL', 'seos-blog' ),
		       	'size' => 48,
		       	'slug' => 'huge'
		   	)
		));

	}
endif;
add_action( 'after_setup_theme', 'seos_blog_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function seos_blog_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'seos_blog_content_width', 790 );
}
add_action( 'after_setup_theme', 'seos_blog_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function seos_blog_widgets_init() {
	register_sidebar( 
		array(
			'name'          => esc_html__( 'Sidebar', 'seos-blog' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'seos-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) 
	);

	register_sidebar(
		array(
			'name'          => __( 'Footer 1', 'seos-blog' ),
			'id'            => 'sidebar-2',
			'description'   => __( 'Add widgets here to appear in your footer.', 'seos-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( 'Footer 2', 'seos-blog' ),
			'id'            => 'sidebar-3',
			'description'   => __( 'Add widgets here to appear in your footer.', 'seos-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( 'Footer 3', 'seos-blog' ),
			'id'            => 'sidebar-4',
			'description'   => __( 'Add widgets here to appear in your footer.', 'seos-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'seos_blog_widgets_init' );

/**
* Enqueue theme fonts.
*/
function seos_blog_fonts() {
	$fonts_url = seos_blog_get_fonts_url();

	// Load Fonts if necessary.
	if ( $fonts_url ) {
		require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );
		wp_enqueue_style( 'seos-blog-fonts', wptt_get_webfont_url( $fonts_url ), array(), SEOS_BLOG_THEME_VERSION );
	}
}
add_action( 'wp_enqueue_scripts', 'seos_blog_fonts', 1 );
add_action( 'enqueue_block_editor_assets', 'seos_blog_fonts', 1 );
/**
* Enqueue theme admin.
*/
function seos_blog_admin() {
 
		wp_enqueue_style( 'seos-blog-admin',  SEOS_BLOG_THEME_URI .'assets/css/admin.css', array(), SEOS_BLOG_THEME_VERSION );
}
add_action( 'admin_enqueue_scripts', 'seos_blog_admin' );

/**
 * Retrieve webfont URL to load fonts locally.
 */
function seos_blog_get_fonts_url() {
	$font_families = array(
		'Roboto:300,400,500,600,700',
	);

	$query_args = array(
		'family'  => urlencode( implode( '|', $font_families ) ),
		'subset'  => urlencode( 'latin,latin-ext' ),
		'display' => urlencode( 'swap' ),
	);

	return apply_filters( 'seos_blog_get_fonts_url', add_query_arg( $query_args, 'https://fonts.googleapis.com/css' ) );
}

/**
 * Enqueue scripts and styles.
 */
function seos_blog_scripts() {
    wp_enqueue_style( 'dashicons' );
	wp_enqueue_style( 'seos-blog-style', get_stylesheet_uri() );
	wp_enqueue_style( 'seos-blog-animate', SEOS_BLOG_THEME_URI . 'assets/css/animate.css', false, SEOS_BLOG_THEME_VERSION );
	if( !get_theme_mod( 'widgets_icons' ) ) {
	    wp_enqueue_style( 'seos-blog-widgets-icons', SEOS_BLOG_THEME_URI . 'assets/css/widgets-icons.css', false, SEOS_BLOG_THEME_VERSION );
	}
	wp_enqueue_script( 'seos-blog-skip-link-focus-fix', SEOS_BLOG_THEME_URI . 'assets/js/skip-link-focus-fix.js', array(), SEOS_BLOG_THEME_VERSION, true );
	wp_enqueue_script( 'seos-blog-navigation', SEOS_BLOG_THEME_URI . 'assets/js/navigation.js', array('jquery'), SEOS_BLOG_THEME_VERSION, true );
	$seos_blog_l10n = array(
		'quote'          => '<span class="dashicons dashicons-arrow-down-alt2"></span>',
		'expand'         => esc_html__( 'Expand child menu', 'seos-blog' ),
		'collapse'       => esc_html__( 'Collapse child menu', 'seos-blog' ),
		'icon'           => '<span class="dashicons dashicons-arrow-down-alt2"></span>',
	);
	
	wp_localize_script( 'seos-blog-navigation', 'seos_blog_l10n', $seos_blog_l10n );

	wp_enqueue_script( 'seos-blog-custom-script', SEOS_BLOG_THEME_URI . 'assets/js/custom.js', array('jquery'), SEOS_BLOG_THEME_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'seos_blog_scripts' );

/**
 * Enqueue editor styles for Gutenberg
 *
 */
function seos_blog_block_editor_styles() {
	// Block styles.
	wp_enqueue_style( 'seos-blog-block-editor-style', get_theme_file_uri( 'assets/css/editor-blocks.css' ), false, SEOS_BLOG_THEME_VERSION );
	// Add custom fonts.
	wp_enqueue_style( 'seos-blog-fonts', seos_blog_get_fonts_url(), array(), SEOS_BLOG_THEME_VERSION );
}
add_action( 'enqueue_block_editor_assets', 'seos_blog_block_editor_styles' );

/**
 * Removing category text from category page.
 */
function seos_blog_category_title( $title ) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    }
    return $title;
}
add_filter( 'get_the_archive_title', 'seos_blog_category_title' );



/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function seos_blog_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Add a class if there is a custom header.
	if ( has_header_image() ) {
		$classes[] = 'has-header-image';
	}

	// Add class if sidebar is used.
	if ( is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'has-sidebar';
	}

	if( is_page() ) {
		$page_sidebar = get_theme_mod( 'page_sidebar', 'no-sidebar' );
		$classes[] = esc_attr( $page_sidebar );
	}

	if( is_single() ) {
		$single_post_sidebar = get_theme_mod( 'single_post_sidebar' , 'right-sidebar' );
		$classes[] = esc_attr( $single_post_sidebar );
	}

	if ( is_home() ) {
		$blog_sidebar = get_theme_mod( 'blog_sidebar' , 'no-sidebar' );
		$classes[] = esc_attr( $blog_sidebar );
	}

	if( is_archive() || is_search() || is_404() ) {
		$archive_sidebar = get_theme_mod( 'archive_sidebar' , 'no-sidebar' );
		$classes[] = esc_attr( $archive_sidebar );
	}

	return $classes;
}
add_filter( 'body_class', 'seos_blog_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function seos_blog_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'seos_blog_pingback_header' );



/**
 * Add dropdown arrrow to top menu.
 *
 */
function seos_blog_dropdown_icon_to_menu_link( $title, $item, $args, $depth ) {
	if ( 'primary_menu' === $args->theme_location ) {
		foreach ( $item->classes as $value ) {
			if ( 'menu-item-has-children' === $value || 'page_item_has_children' === $value ) {
				$title = $title . '<span class="dashicons dashicons-arrow-down-alt2"></span>';
			}
		}
	}

	if ( 'top_header_menu' === $args->theme_location ) {
		foreach ( $item->classes as $value ) {
			if ( 'menu-item-has-children' === $value || 'page_item_has_children' === $value ) {
				$title = $title . '<span class="dashicons dashicons-arrow-down-alt2"></span>';
			}
		}
	}

	return $title;
}
add_filter( 'nav_menu_item_title', 'seos_blog_dropdown_icon_to_menu_link', 10, 4 );

/**
 * Header Image - Zoom Animation Speed
 */
function seos_blog__heade_image_zoom_speed()
{
    ?>
	-webkit-animation: header-image 
	<?php 
    
    if ( get_theme_mod( 'header_zoom_speed' ) ) {
        echo  esc_attr( get_theme_mod( 'header_zoom_speed' ) ) ;
    } else {
        echo  "80" ;
    }
    
    ?>s ease-out both; 
	animation: header-image
	<?php 
    
    if ( get_theme_mod( 'header_zoom_speed' ) ) {
        echo  esc_attr( get_theme_mod( 'header_zoom_speed' ) ) ;
    } else {
        echo  "80" ;
    }
    
    ?>s ease-out 0s 1 normal both running;
<?php 
}
/**
 * Header Image Animation
 */
function seos_blog__header_image_zoom()
{
    if ( !get_theme_mod( 'seos_blog__header_zoom' ) ) {
        ?>
		<style>
@-webkit-keyframes header-image {
  0% {
    -webkit-transform: scale(1) translateY(0);
            transform: scale(1) translateY(0);
    -webkit-transform-origin: 50% 16%;
            transform-origin: 50% 16%;
  }
  100% {
    -webkit-transform: scale(1.25) translateY(-15px);
            transform: scale(1.25) translateY(-15px);
    -webkit-transform-origin: top;
            transform-origin: top;
  }
}
@keyframes header-image {
  0% {
    -webkit-transform: scale(1) translateY(0);
            transform: scale(1) translateY(0);
    -webkit-transform-origin: 50% 16%;
            transform-origin: 50% 16%;
  }
  100% {
    -webkit-transform: scale(1.25) translateY(-15px);
            transform: scale(1.25) translateY(-15px);
    -webkit-transform-origin: top;
            transform-origin: top;
  }
}
	</style>
	<?php 
    }
}

add_action( 'wp_head', 'seos_blog__header_image_zoom' );

require SEOS_BLOG_THEME_DIR . 'inc/custom-header.php';
require SEOS_BLOG_THEME_DIR . 'inc/template-tags.php';
require SEOS_BLOG_THEME_DIR . 'inc/customizer.php';
require SEOS_BLOG_THEME_DIR . 'inc/customizer/customize-options.php';
require SEOS_BLOG_THEME_DIR . 'inc/read-more.php';
require SEOS_BLOG_THEME_DIR . 'inc/customize-pro/class-customize.php';
require SEOS_BLOG_THEME_DIR . 'inc/pro/pro.php';
require SEOS_BLOG_THEME_DIR . 'inc/recent-post-slider/slider.php';
require SEOS_BLOG_THEME_DIR . 'inc/recent-post-widget/widget.php';
require SEOS_BLOG_THEME_DIR . 'inc/before-header.php';
require SEOS_BLOG_THEME_DIR . 'inc/sc.php';

