<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package seos_blog
 */

?>
	</div><!-- #content -->
	<?php
		if ( (is_front_page() or is_home() ) and get_theme_mod( 'seos_blog_recent_post_home', false ) ) {
			echo seos_blog_recent_post_slider();	
		}
	?>
	<footer id="colophon" class="site-footer" itemscope="itemscope" itemtype="http://schema.org/WPFooter">
		<?php if ( is_active_sidebar( 'sidebar-2' ) || is_active_sidebar( 'sidebar-3' ) || is_active_sidebar( 'sidebar-4' ) ) : ?>
			<div id="footer-widgets" class="container">
				<?php
					get_template_part( 'inc/footer', 'widgets' );
				?>
			</div><!-- .container -->
		<?php endif; ?>

		<div class="site-info">
			<div class="container">
				<?php
				$copyright_text = sprintf( __( 'Theme SEOS Blog by %s', 'seos-blog' ), '<a target="_blank" rel="designer" href="'.esc_url( 'https://seosthemes.com/' ).'">'. esc_html__( 'SEOS Themes', 'seos-blog' ). '</a>' ); ?>

				<?php echo $copyright_text; ?>
			</div><!-- .container -->
		</div><!-- .site-info -->
	</footer><!-- #colophon -->

	<a href="#page" class="to-top"><span class="dashicons dashicons-arrow-up-alt2"></span></a>
	
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
