<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Real Estate Pack
 */

$real_estate_pack_lite_blog_container = get_theme_mod('real_estate_pack_blog_container', 'container');
$real_estate_pack_lite_blog_layout = get_theme_mod('real_estate_pack_blog_layout', 'rightside');
$realestate_pack_lite_blog_style = get_theme_mod('realestate_pack_lite_blog_style', 'grid');

if (is_active_sidebar('sidebar-1') && $real_estate_pack_lite_blog_layout != 'fullwidth') {
	$real_estate_pack_lite_blog_column = 'col-lg-9';
} else {
	$real_estate_pack_lite_blog_column = 'col-lg-12';
}
get_header();
?>

<div class="<?php echo esc_attr($real_estate_pack_lite_blog_container); ?> mt-5 mb-5 pt-5 pb-5">
	<div class="row main-content">
		<?php if (is_active_sidebar('sidebar-1') && $real_estate_pack_lite_blog_layout == 'leftside') : ?>
			<div class="col-lg-3 widget-sidebar">
				<?php get_sidebar(); ?>
			</div>
		<?php endif; ?>
		<div class="<?php echo esc_attr($real_estate_pack_lite_blog_column); ?> site-content">
			<main id="primary" class="site-main">


				<?php if (have_posts()) : ?>

					<header class="page-header search-header shadow-sm p-4 mb-5 text-center">
						<h1 class="page-title">
							<?php
							/* translators: %s: search query. */
							printf(esc_html__('Search Results for: %s', 'real-estate-pack'), '<span>' . get_search_query() . '</span>');
							?>
						</h1>
					</header><!-- .page-header -->

					<?php
					if ($realestate_pack_lite_blog_style == 'grid') :
					?>
						<div class="row" data-masonry='{"percentPosition": true }'>

						<?php
					endif;
					/* Start the Loop */
					while (have_posts()) :
						the_post();

						get_template_part('template-parts/content', get_post_type());


					endwhile;
					if ($realestate_pack_lite_blog_style == 'grid') :
						?>
						</div>
					<?php
					endif;
					?>

				<?php

					the_posts_pagination();

				else :

					get_template_part('template-parts/content', 'none');

				endif;
				?>

			</main><!-- #main -->
		</div>
		<?php if (is_active_sidebar('sidebar-1') && $real_estate_pack_lite_blog_layout == 'rightside') : ?>
			<div class="col-lg-3 widget-sidebar">
				<?php get_sidebar(); ?>
			</div>
		<?php endif; ?>
	</div>
</div>

<?php
get_footer();
