<?php

/**
 * Realestate Pack Lite Theme Customizer
 *
 * @package Realestate Pack Lite
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */


function realestate_pack_lite_customize_register($wp_customize)
{

    $wp_customize->remove_control('realestate_pack_lite_blog_style');

    $wp_customize->add_setting('realestate_pack_lite_blog_style', array(
        'default'        => 'grid',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'real_estate_pack_sanitize_select',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('realestate_pack_lite_blog_style', array(
        'label'      => __('Select Blog Style', 'realestate-pack-lite'),
        'section'    => 'real_estate_pack_blog',
        'settings'   => 'realestate_pack_lite_blog_style',
        'type'       => 'select',
        'choices'    => array(
            'grid' => __('Grid Style', 'realestate-pack-lite'),
            'classic' => __('Classic Style', 'realestate-pack-lite'),
            'list' => __('List Style', 'realestate-pack-lite'),
        ),
    ));
}
add_action('customize_register', 'realestate_pack_lite_customize_register', 99);
