<?php
/*This file is part of BeShop child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

if (! defined('REALESTATE_PACK_LITE_VERSION')) {
	$realestate_pack_lite_theme = wp_get_theme();
	define('REALESTATE_PACK_LITE_VERSION', $realestate_pack_lite_theme->get('Version'));
}


/**
 * Register custom fonts.
 */
function realestate_pack_lite_fonts_url()
{
	$fonts_url = '';

	$font_families = array();

	$font_families[] = 'Roboto:400,400i,700,700i';
	$font_families[] = 'Mukta:400,400i,500,600,700,700i';

	$query_args = array(
		'family' => urlencode(implode('|', $font_families)),
		'subset' => urlencode('latin,latin-ext'),
	);

	$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');


	return esc_url_raw($fonts_url);
}

function realestate_pack_lite_enqueue_child_styles()
{
	wp_enqueue_style('realestate-pack-lite-google-font', realestate_pack_lite_fonts_url(), array(), null);
	wp_enqueue_style('realestate-pack-lite-parent-style', get_template_directory_uri() . '/style.css', array('bootstrap', 'real-estate-pack-main-style', 'real-estate-pack-default-style'), REALESTATE_PACK_LITE_VERSION, 'all');
	wp_enqueue_style('realestate-pack-lite-style', get_stylesheet_directory_uri() . '/assets/css/main-style.css', array(), REALESTATE_PACK_LITE_VERSION, 'all');
}
add_action('wp_enqueue_scripts', 'realestate_pack_lite_enqueue_child_styles');




/**
 * Customizer additions.
 */

require get_stylesheet_directory() . '/inc/customizer.php';



function realestate_pack_lite_excerpt_length($length)
{

	if (!is_admin()) {
		return 25;
	}
	return $length;
}
add_filter('excerpt_length', 'realestate_pack_lite_excerpt_length');
