<?php
if ( ! get_theme_mod( 'radiant_blog_enable_flash_articles_section', false ) ) {
	return;
}

$content_ids  = array();
$content_type = get_theme_mod( 'radiant_blog_flash_articles_content_type', 'post' );

if ( $content_type === 'post' ) {

	for ( $i = 1; $i <= 3; $i++ ) {
		$content_ids[] = get_theme_mod( 'radiant_blog_flash_articles_content_post_' . $i );
	}

	$args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $content_ids ) ) ) {
		$args['post__in'] = array_filter( $content_ids );
		$args['orderby']  = 'post__in';
	} else {
		$args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'radiant_blog_flash_articles_content_category' );
	$args           = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3 ),
	);
}

$args = apply_filters( 'radiant_blog_flash_articles_section_args', $args );

radiant_blog_render_flash_articles_section( $args );

/**
 * Render Flash Articles Section.
 */
function radiant_blog_render_flash_articles_section( $args ) {
	$section_title = get_theme_mod( 'radiant_blog_flash_articles_title', __( 'Flash Articles', 'radiant-blog' ) );

	$query = new WP_Query( $args );
	if ( $query->have_posts() ) :
		?>

		<section id="radiant_blog_flash_articles_section" class="flash-article-section section-splitter">
			<?php
			if ( is_customize_preview() ) :
				radiant_blog_section_link( 'radiant_blog_flash_articles_section' );
			endif;
			?>
			<div class="section-wrapper">
				<div class="flash-article-wrapper">
					<div class="title-part">
						<span><?php echo esc_html( $section_title ); ?></span>
					</div>
					<div class="flash-article-part">
						<div class="flash-article slick-button">
							<?php
							while ( $query->have_posts() ) :
								$query->the_post();
								?>
								<div class="blog-post-container">
									<div class="blog-post-inner <?php echo esc_attr( has_post_thumbnail() ? '' : 'no-thumbnail' ); ?>">
										<?php if ( has_post_thumbnail() ) : ?>
											<div class="blog-post-image">
												<?php the_post_thumbnail( array( 40, 40 ) ); ?>
											</div>
										<?php endif ?>
										<div class="blog-post-detail">
											<h3 class="post-main-title">
												<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
											</h3>
										</div>
									</div>
								</div>
								<?php
							endwhile;
							wp_reset_postdata();
							?>
						</div>
						<div class="trend-navigation"></div>
					</div>
				</div>
			</div>
		</section>

		<?php
	endif;
}
