<?php
/**
 * Flash Articles Section
 *
 * @package Radiant Blog
 */

$wp_customize->add_section(
	'radiant_blog_flash_articles_section',
	array(
		'panel' => 'dazzling_blog_front_page_options',
		'title' => esc_html__( 'Flash Articles Section', 'radiant-blog' ),
	)
);

// Flash Articles Section - Enable Section.
$wp_customize->add_setting(
	'radiant_blog_enable_flash_articles_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'dazzling_blog_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Dazzling_Blog_Toggle_Switch_Custom_Control(
		$wp_customize,
		'radiant_blog_enable_flash_articles_section',
		array(
			'label'    => esc_html__( 'Enable Flash Articles Section', 'radiant-blog' ),
			'section'  => 'radiant_blog_flash_articles_section',
			'settings' => 'radiant_blog_enable_flash_articles_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'radiant_blog_enable_flash_articles_section',
		array(
			'selector' => '#radiant_blog_flash_articles_section .section-link',
			'settings' => 'radiant_blog_enable_flash_articles_section',
		)
	);
}

// Flash Articles Section - Section Title.
$wp_customize->add_setting(
	'radiant_blog_flash_articles_title',
	array(
		'default'           => __( 'Flash Articles', 'radiant-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'radiant_blog_flash_articles_title',
	array(
		'label'           => esc_html__( 'Section Title', 'radiant-blog' ),
		'section'         => 'radiant_blog_flash_articles_section',
		'settings'        => 'radiant_blog_flash_articles_title',
		'type'            => 'text',
		'active_callback' => 'radiant_blog_is_flash_articles_section_enabled',
	)
);

// Flash Articles Section - Content Type.
$wp_customize->add_setting(
	'radiant_blog_flash_articles_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'dazzling_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'radiant_blog_flash_articles_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'radiant-blog' ),
		'section'         => 'radiant_blog_flash_articles_section',
		'settings'        => 'radiant_blog_flash_articles_content_type',
		'type'            => 'select',
		'active_callback' => 'radiant_blog_is_flash_articles_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'radiant-blog' ),
			'category' => esc_html__( 'Category', 'radiant-blog' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Flash Articles Section - Select Post.
	$wp_customize->add_setting(
		'radiant_blog_flash_articles_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'radiant_blog_flash_articles_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'radiant-blog' ), $i ),
			'section'         => 'radiant_blog_flash_articles_section',
			'settings'        => 'radiant_blog_flash_articles_content_post_' . $i,
			'active_callback' => 'radiant_blog_is_flash_articles_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => dazzling_blog_get_post_choices(),
		)
	);

}

// Flash Articles Section - Select Category.
$wp_customize->add_setting(
	'radiant_blog_flash_articles_content_category',
	array(
		'sanitize_callback' => 'dazzling_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'radiant_blog_flash_articles_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'radiant-blog' ),
		'section'         => 'radiant_blog_flash_articles_section',
		'settings'        => 'radiant_blog_flash_articles_content_category',
		'active_callback' => 'radiant_blog_is_flash_articles_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => dazzling_blog_get_post_cat_choices(),
	)
);
