<?php 
$techup_enable_testimonial_section = get_theme_mod( 'techup_enable_testimonial_section', false );
$techup_testimonial_title= get_theme_mod( 'techup_testimonial_title','What People Say');
$techup_testimonial_subtitle= get_theme_mod( 'techup_testimonial_subtitle');

if($techup_enable_testimonial_section == true ) {
	$techup_testimonials_no        = 6;
	$techup_testimonials_pages      = array();
	for( $i = 1; $i <= $techup_testimonials_no; $i++ ) {
		 $techup_testimonials_pages[] = get_theme_mod('techup_testimonial_page'.$i);
	}
	$techup_testimonials_args  = array(
	'post_type' => 'page',
	'post__in' => array_map( 'absint', $techup_testimonials_pages ),
	'posts_per_page' => absint($techup_testimonials_no),
	'orderby' => 'post__in'
	); 
	$techup_testimonials_query = new WP_Query( $techup_testimonials_args );
?>
 	<!-- ======= Testimonials Section ======= -->
  
 <section class="client-testimonial-5">
      <div class="container">
        <div class="row client-testimonials owl-carousel owl-theme text-center">   
        <?php
          $count = 0;
          while($techup_testimonials_query->have_posts() && $count <= 5 ) :
          $techup_testimonials_query->the_post();
        ?>     
           <div class="client-testimonial">
              <h1><?php echo esc_html($techup_testimonial_title); ?></h1>
              <?php if($techup_testimonial_subtitle) : ?>
          <p><?php echo esc_html($techup_testimonial_subtitle); ?></p>
          <?php endif; ?>
           <div class="testimonials-title">
             <h5 class="testimonial-title"><?php the_title(); ?></h5>
             <p class="testimonial-para"><?php echo get_the_author(); ?></p>
           </div>
         </div>
         <?php
        $count = $count + 1;
        endwhile;
        wp_reset_postdata();
          ?>
         </div>
       </div>
     </section>
     
	 <!-- End Testimonials Section ---->

<?php } ?>