<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( get_header_image() ) : ?>
<div id="site-header"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"> <img src="<?php header_image(); ?>" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt=""> </a> </div>
<?php endif; ?>
<div id="wrap">
<header id="header">
  <div id="logo">
    <h1 id="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
      <?php bloginfo( 'name' ); ?>
      </a></h1>
    <div id="description">
      <?php
    $description = get_bloginfo( 'description', 'display' );
    if ( ! empty ( $description ) ) :
  ?>
      <h2 id="site-description"><?php echo esc_html( $description ); ?></h2>
      <?php endif; ?>
    </div>
  </div>
  <div id="head-nav">
    <nav id="primary-navigation" class="site-navigation primary-navigation" role="navigation">
      <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
    </nav>
  </div>
  <div class="clear"> </div>
</header>
<div id="main">
