<?php
if ( ! function_exists( 'oxbox_setup' ) ) :
/**
 * oxtheme setup.
 *
 */
function oxbox_setup() {
	if ( ! isset( $content_width ) ) $content_width = 600;

	/*
	 * Make oxtheme available for translation.
	 *
	 * Translations can be added to the /languages/ directory.
	 */
	load_theme_textdomain( 'oxbox', get_template_directory() . '/languages' );


	// Add RSS feed links to <head> for posts and comments.
	add_theme_support( 'automatic-feed-links' );

	// Enable support for Post Thumbnails, and declare two sizes.
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 600, 372, true );

	// This theme styles the visual editor to resemble the theme style.
	add_editor_style( array( 'extra/editor-style.css') );


	// This theme uses wp_nav_menu in two locations.
	register_nav_menus( array(
		'primary'   => __( 'Top primary menu', 'oxbox' ),
	) );

	// This theme allows users to set a custom background.
	add_theme_support( 'custom-background', apply_filters( 'oxbox_custom_background_args', array(
		'default-color' => 'f5f5f5',
	) ) );
	
	add_theme_support( 'title-tag' );
}
endif; // oxbox_setup
add_action( 'after_setup_theme', 'oxbox_setup' );

/**
 * Enqueue scripts and styles for the front end.
 *
 */
function oxbox_scripts() {

	// Load our main stylesheet.
	wp_enqueue_style( 'oxbox-style', get_stylesheet_uri() );
    
    /**
     * Load our IE specific stylesheet for a range of older versions:
     * <!--[if lt IE 9]> ... <![endif]-->
     */

    wp_enqueue_script( 'oxbox-old-ie', get_template_directory_uri() . "/extra/html5.js");
    wp_script_add_data( 'oxbox-old-ie', 'conditional', 'lt IE 9' );



	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'oxbox_scripts' );


/**
 * Register three oxtheme widget areas.
 *
 */
function oxbox_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Primary Sidebar', 'oxbox' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Main sidebar that appears on the left.', 'oxbox' ),
		'before_widget' => '<aside id="%1$s" class="box %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Wide Widget Area', 'oxbox' ),
		'id'            => 'sidebar-2',
		'description'   => __( '160px Wide Widget', 'oxbox' ),
		'before_widget' => '<aside id="%1$s" class="box %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Narrow Widget Area', 'oxbox' ),
		'id'            => 'sidebar-3',
		'description'   => __( '140px Wide Widget.', 'oxbox' ),
		'before_widget' => '<aside id="%1$s" class="box %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'oxbox_widgets_init' );


if ( ! function_exists( 'oxbox_paging_nav' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
 */
function oxbox_paging_nav() {

	$links = paginate_links();

	if ( $links ) :

	?>
	<nav class="pagination" role="navigation">
			<?php echo $links; ?>
	</nav><!-- .navigation -->
	<?php
	endif;
}
endif;



if ( ! function_exists( 'oxbox_post_nav' ) ) :
/**
 * Display navigation to next/previous post when applicable.
 *
 */
function oxbox_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}

	?>
	<nav class="navigation post-navigation" id="postnavi" role="navigation">
			<?php
			if ( is_attachment() ) :
				previous_post_link( '%link', __( '<span class="meta-nav">Published In</span>%title', 'oxbox' ) );
			else :
				previous_post_link( __( '<div class="sleft">&laquo; %link</div>', 'oxbox' ), '%title');
				next_post_link( __( '<div class="sright">%link &raquo;</div>', 'oxbox' ),'%title');
			endif;
			?>
	</nav><!-- .navigation -->
	<?php
}
endif; 


/**
 * Display an optional post thumbnail.
 *
 * Wraps the post thumbnail in an anchor element on index
 * views, or a div element when on single views.
 *
 */
function oxbox_post_thumbnail() {
	if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
		return;
	}

	if ( is_singular() ) :
	?>

	<div class="post-thumbnail">
	<?php
			the_post_thumbnail();
	?>
	</div>

	<?php else : ?>

	<a class="post-thumbnail" href="<?php the_permalink(); ?>">
	<?php
			the_post_thumbnail();
	?>
	</a>

	<?php endif; // End is_singular
}


/**
 * Set up the WordPress core custom header settings.
 *
 *
 */
function oxbox_custom_header_setup() {
	/**
	 * Filter oxtheme custom-header support arguments.
	 */
	add_theme_support( 'custom-header', apply_filters( 'oxbox_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 1290,
		'height'                 => 240,
		'flex-height'            => true,
	) ) );
}
add_action( 'after_setup_theme', 'oxbox_custom_header_setup' );


function oxbox_filter_post_empty_title($title){
if($title == ''){
$time = get_the_time('Y-m-d');
$title = $time;
}
return $title;
}
add_filter('the_title','oxbox_filter_post_empty_title');