<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <header class="entry-header">
    <?php
			if ( is_single() ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				the_title( '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
			endif;
		?>
  </header>
  <!-- .entry-header -->
  
  <?php if ( is_search() ) : ?>
  <div class="entry">
    <?php the_excerpt(); ?>
  </div>
  <!-- .entry-summary -->
  <?php else : ?>
  <div class="entry">
    <?php
			oxbox_post_thumbnail();
			the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'oxbox' ) );
			wp_link_pages( array(
        'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'oxbox' ) . '</span>',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
      ) );
		?>
  </div>
  <!-- .entry-content -->
  <?php endif; ?>
  <footer class="postmeta">
    <?php the_time('F j, Y') ;?>
    <?php printf('|'); ?>
	<?php printf( __( 'Category: %s', 'oxbox' ), get_the_category_list(', ')); ?>
    <?php if (is_single()) : ?>
    <?php printf('|'); ?>
    <?php _e( 'Tag:', 'oxbox' ); ?>
    <?php the_tags('', ', '); ?>
    <?php else: ?>
    <?php
        if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) :
      ?>
    <span class="comments-link">
    <?php printf('|'); ?>
    <?php comments_popup_link( __( 'Leave a comment', 'oxbox' ), __( '1 Comment', 'oxbox' ), __( '% Comments', 'oxbox' ) ); ?>
    </span>
    <?php endif; ?>
    <?php endif; ?>
  </footer>
</article>
<!-- #post-## --> 
