<?php
if ( post_password_required() ) {
	return;
}
?>

<div id="comments">
  <?php if ( have_comments() ) : ?>
  <div id="comments-title">
    <?php
    if(get_comments_number()==1) {
        _e('One thought', 'oxbox');
    } else {
        printf( __( '%s thoughts', 'oxbox' ), get_comments_number());
    }
		?>
  </div>
  <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
  <nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
    <h1 class="screen-reader-text">
      <?php _e( 'Comment navigation', 'oxbox' ); ?>
    </h1>
    <div class="nav-previous">
      <?php previous_comments_link( __( '&larr; Older Comments', 'oxbox' ) ); ?>
    </div>
    <div class="nav-next">
      <?php next_comments_link( __( 'Newer Comments &rarr;', 'oxbox' ) ); ?>
    </div>
  </nav>
  <!-- #comment-nav-above -->
  <?php endif; // Check for comment navigation. ?>
  <ol class="comment-list">
    <?php
			wp_list_comments( array(
				'style'      => 'ol',
				'short_ping' => true,
				'avatar_size'=> 34,
			) );
		?>
  </ol>
  <!-- .comment-list -->
  
  <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
  <nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
    <h1 class="screen-reader-text">
      <?php _e( 'Comment navigation', 'oxbox' ); ?>
    </h1>
    <div class="nav-previous">
      <?php previous_comments_link( __( '&larr; Older Comments', 'oxbox' ) ); ?>
    </div>
    <div class="nav-next">
      <?php next_comments_link( __( 'Newer Comments &rarr;', 'oxbox' ) ); ?>
    </div>
  </nav>
  <!-- #comment-nav-below -->
  <?php endif; // Check for comment navigation. ?>
  <?php if ( ! comments_open() ) : ?>
  <p class="no-comments">
    <?php _e( 'Comments are closed.', 'oxbox' ); ?>
  </p>
  <?php endif; ?>
  <?php endif; // have_comments ?>
  <?php comment_form(); ?>
</div>
