<?php get_header();?>

<div id="content">
  <?php if ( have_posts() ) : ?>
  <header class="page-header">
    <h1 class="page-title">
      <?php
						if ( is_day() ) :
							printf( __( 'Daily Archives: %s', 'oxbox' ), get_the_date() );

						elseif ( is_month() ) :
							printf( __( 'Monthly Archives: %s', 'oxbox' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'oxbox' ) ) );

						elseif ( is_year() ) :
							printf( __( 'Yearly Archives: %s', 'oxbox' ), get_the_date( _x( 'Y', 'yearly archives date format', 'oxbox' ) ) );

						else :
							_e( 'Archives', 'oxbox' );

						endif;
					?>
    </h1>
  </header>
  <!-- .page-header -->
  
  <?php
					// Start the Loop.
					while ( have_posts() ) : the_post();

						get_template_part( 'content' );

					endwhile;
					// Previous/next page navigation.
					oxbox_paging_nav();

				else :
					// If no content, include the "No posts found" template.
					get_template_part( 'content', 'none' );

				endif;
			?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
