<?php

/**
 * Option Panel
 *
 * @package Newsbes
 */


function newsbes_customize_register($wp_customize) {

    $newsup_default = newsbes_get_default_theme_options();

    $wp_customize->remove_control('newsup_select_slider_setting');
    $wp_customize->remove_control('popular_tab_title');

    $wp_customize->remove_section('newsup_popular_tags_section_settings');

    $wp_customize->get_setting('newsup_title_font_size')->default  = '46'; 
    $wp_customize->get_setting('newsup_header_overlay_color')->default  = '#F9FAFF';

    //section title
    $wp_customize->add_setting('trending_post_section_title',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new newsup_Section_Title(
            $wp_customize,
            'trending_post_section_title',
            array(
                'label'             => esc_html__( 'Treanding Post Section', 'newsbes' ),
                'section'           => 'frontpage_main_banner_section_settings',
                'priority'          => 60,
                'active_callback' => 'newsup_main_banner_section_status'
            )
        )
    );
    // Setting - drop down category for slider.
    $wp_customize->add_setting('select_trending_news_category',
        array(
            'default' => $newsup_default['select_trending_news_category'],
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(new Newsup_Dropdown_Taxonomies_Control($wp_customize, 'select_trending_news_category',
        array(
            'label' => esc_html__('Category', 'newsbes'),
            'description' => esc_html__('Posts to be shown on trending 4 Posts', 'newsbes'),
            'section' => 'frontpage_main_banner_section_settings',
            'type' => 'dropdown-taxonomies',
            'taxonomy' => 'category',
            'priority' => 60,
            'active_callback' => 'newsup_main_banner_section_status'
        )
    ));

    //section title
    $wp_customize->add_setting('recent_post_section_title',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        new newsup_Section_Title(
            $wp_customize,
            'recent_post_section_title',
            array(
                'label'             => esc_html__( 'Recent Post Section', 'newsbes' ),
                'section'           => 'frontpage_main_banner_section_settings',
                'priority'          => 60,
                'active_callback' => 'newsup_main_banner_section_status'
            )
        )
    );
    // Setting - drop down category for slider.
    $wp_customize->add_setting('select_recent_news_category',
        array(
            'default' => $newsup_default['select_recent_news_category'],
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(new Newsup_Dropdown_Taxonomies_Control($wp_customize, 'select_recent_news_category',
        array(
            'label' => esc_html__('Category', 'newsbes'),
            'description' => esc_html__('Posts to be shown on Recent 1 Post', 'newsbes'),
            'section' => 'frontpage_main_banner_section_settings',
            'type' => 'dropdown-taxonomies',
            'taxonomy' => 'category',
            'priority' => 60,
            'active_callback' => 'newsup_main_banner_section_status'
        )
    ));
}
add_action('customize_register', 'newsbes_customize_register');
