<?php
/**
 * Header layout default
 *
 * @package News Portal
 * @subpackage News Promo
 *
 */
?>

<header id="masthead" class="site-header" role="banner">

	<div class="np-logo-section-wrapper">
		<div class="mt-container">

			<div class="site-branding">

				<?php if ( the_custom_logo() ) { ?>
					<div class="site-logo">
						<?php the_custom_logo(); ?>
					</div><!-- .site-logo -->
				<?php } ?>

				<?php
				if ( is_front_page() && is_home() ) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php elseif ( is_front_page() && is_page_template( 'templates/template-home.php' ) ) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php else : ?>
					<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
				endif;

				$description = get_bloginfo( 'description', 'display' );
				if ( $description || is_customize_preview() ) : ?>
					<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
				<?php
				endif; ?>
				
			</div><!-- .site-branding -->

			<div class="np-header-ads-area">
				<?php
					if ( is_active_sidebar( 'news_portal_header_ads_area' ) ) {
						dynamic_sidebar( 'news_portal_header_ads_area' );
					}
				?>
			</div><!-- .np-header-ads-area -->

		</div><!-- .mt-container -->
	
	</div><!-- .np-logo-section-wrapper -->

	<div id="np-menu-wrap" class="np-header-menu-wrapper">
		<div class="np-header-menu-block-wrap">
			<div class="mt-container">
				<?php
					$news_portal_home_icon_option = news_portal_get_customizer_option_value( 'news_portal_home_icon_option' );
					if ( $news_portal_home_icon_option == true ) {
				?>
						<div class="np-home-icon">
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"> <i class="fa fa-home"> </i> </a>
						</div><!-- .np-home-icon -->
				<?php } ?>
				<div class="mt-header-menu-wrap">
					<a href="javascript:void(0)" class="menu-toggle hide"><i class="fa fa-navicon"> </i> </a>
					<nav id="site-navigation" class="main-navigation" role="navigation">
						<?php
							wp_nav_menu( 
								array( 
									'theme_location' => 'news_portal_primary_menu',
									'menu_id' => 'primary-menu'
								)
							);
						?>
					</nav><!-- #site-navigation -->
				</div><!-- .mt-header-menu-wrap -->
				<div class="np-icon-elements-wrapper">
					<?php
						news_portal_site_mode_switcher();
						
						$news_portal_search_icon_option = news_portal_get_customizer_option_value( 'news_portal_search_icon_option' );
						if ( $news_portal_search_icon_option == true ) {
					?>
						<div class="np-header-search-wrapper">                    
			                <span class="search-main"><a href="javascript:void(0)"><i class="fa fa-search"></i></a></span>
			                <div class="search-form-main np-clearfix">
				                <?php get_search_form(); ?>
				            </div>
						</div><!-- .np-header-search-wrapper -->
					<?php } ?>
				</div> <!-- .np-icon-elements-wrapper -->
			</div>
		</div>
	</div><!-- .np-header-menu-wrapper -->

</header>