<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package News Portal
 * @subpackage News Promo
 */

?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}

	/**
     * news_portal_before_page hook
     *
     * @since 1.0.0
     */
    do_action( 'news_portal_before_page' );
?>

<div id="page" class="site">

	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'news-portal' ) ;?></a>

	<?php
		$news_portal_top_header_option = news_portal_get_customizer_option_value( 'news_portal_top_header_option' );
		if ( $news_portal_top_header_option == true ) {
			
			/**
		     * news_portal_top_header hook
		     *
		     * @hooked - news_portal_top_header_start - 5
		     * @hooked - news_portal_top_left_section - 10
		     * @hooked - news_portal_top_right_section - 15
		     * @hooked - news_portal_top_header_end - 20
		     *
		     * @since 1.0.0
		     */
		    do_action( 'news_portal_top_header' );
		}

		/**
		 * Header section
		 */
	    $news_promo_header_layout = get_theme_mod( 'news_promo_header_layout', 'default' );
	    switch ( $news_promo_header_layout ) {
	    	case 'layout1':
	    		get_template_part( 'layouts/header/layout', 'one' );
	    		break;

	    	default:
	    		get_template_part( 'layouts/header/layout', 'default' );
	    		break;
	    }
	    
		$news_portal_ticker_option = news_portal_get_customizer_option_value( 'news_portal_ticker_option' );
		if ( $news_portal_ticker_option == true && is_front_page() ) {

			/**
		     * news_portal_top_header hook
		     *
		     * @hooked - news_portal_ticker_section_start - 5
		     * @hooked - news_portal_ticker_content - 10
		     * @hooked - news_portal_ticker_section_end - 15
		     *
		     * @since 1.0.0
		     */
		    do_action( 'news_portal_ticker_section' );
		}
	?>

	<div id="content" class="site-content">
		<div class="mt-container">