<?php
/**
 * Infinite Scroll Support
 * See: http://jetpack.me/support/infinite-scroll/
 *
 * Theme Name: Minipress
 */

/**
 * Add theme support for Infinite Scroll.
 */
function obox_infinite_scroll_init() {
	add_theme_support( 'infinite-scroll', array(
		'container' => 'post-container',
		'footer_widgets' => ( ( ( class_exists( 'Jetpack_User_Agent_Info' ) && method_exists( 'Jetpack_User_Agent_Info', 'is_ipad' ) && Jetpack_User_Agent_Info::is_ipad() ) || ( function_exists( 'jetpack_is_mobile' ) && jetpack_is_mobile() ) ) || is_active_sidebar( 'footer' ) ),
		'render'    => 'obox_infinite_scroll_render',
		'posts_per_page' => get_option( 'posts_per_page' ),
		'footer'    => 'content-container',
		'wrapper'	=> false,
	) );
}
add_action( 'after_setup_theme', 'obox_infinite_scroll_init' );

/**
 * Set the code to be rendered on for calling posts, hooked to template parts when possible.
 *
 * Note: must define a loop.
 */
function obox_infinite_scroll_render() {
	while ( have_posts() ) : the_post();
		get_template_part( 'content', 'list' );
	endwhile;
}
