<?php
/**
 * Minipress custom headers
 *
 * @package Minipress
 * @since Minipress 1.0
 *
 * @uses obox_header_style()
 * @uses obox_admin_header_style()
 * @uses obox_admin_header_image()
 *
 */
function obox_custom_header_setup() {
	$args = array(
		'default-image'          => '',
		'default-text-color'     => '000',
		'width'                  => 940,
		'height'                 => 250,
		'flex-height'            => true,
		'flex-width'             => true,
		'wp-head-callback'       => 'obox_header_style',
		'admin-head-callback'    => 'obox_admin_header_style',
		'admin-preview-callback' => 'obox_admin_header_image',
	);

	$args = apply_filters( 'obox_custom_header_args', $args );
	add_theme_support( 'custom-header', $args );
}
add_action( 'after_setup_theme', 'obox_custom_header_setup' );

if ( ! function_exists( 'obox_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see obox_custom_header_setup().
 */
function obox_header_style() {
	// If no custom options for text are set, let's bail
	if ( 'blank' == get_header_textcolor() )
		return;

	// get_header_textcolor() options: HEADER_TEXTCOLOR is default, hide text (returns 'blank') or any hex value
	if ( HEADER_TEXTCOLOR == get_header_textcolor() )
		return;

	// If we're still on course, let's apply the header styling. ?>
		<style type="text/css">
			.logo h1 a {
				color: #<?php echo get_header_textcolor(); ?>;
			}
		</style>
	<?php
}
endif; // obox_header_style

if ( ! function_exists( 'obox_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * @see obox_custom_header_setup().
 */
function obox_admin_header_style() { ?>
	<style type="text/css">
		/*-----------------------------------*/
		/*- HEADER ROW ----------------------*/
		.logo{margin-bottom: 20px; max-width: 940px;}
		.logo h1 {padding: 0; margin: 0;}
		.logo h1 a {text-decoration: none; font-weight: normal; font-size: 35px; line-height: 40px; font-family: 'Rochester', Georgia, Times, cursive;}
		.logo h1 a:hover{color: #999657;}

			/*-------------------------------*/
			/*- TAGLINE ---------------------*/
			.tagline{font-family: 'PT Serif', Georgia, Times, serif; padding: 0px; margin: 0px 0px 0px; font-size: 15px; color: #777;}
		.logo  img{ margin-top: 20px; max-width: 940px; }
	</style>
<?php
}
endif; // obox_admin_header_style

if ( ! function_exists( 'obox_admin_header_image' ) ) :
/**
 * Custom header image markup displayed on the Appearance > Header admin panel.
 *
 * @see obox_custom_header_setup().
 */
function obox_admin_header_image() { ?>
	<div class="logo">

		<?php
		if ( 'blank' == get_header_textcolor() || '' == get_header_textcolor() )
			$style = ' style="display:none;"';
		else
			$style = ' style="color:#' . get_header_textcolor() . ';"';
		?>
		<h1 class="site-title"><a id="name"<?php echo $style; ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
		<?php if ( 'blank' != get_header_textcolor() && '' != get_bloginfo( 'description' ) ) : ?>
			<div class="tagline"><?php bloginfo( 'description' ); ?></div>
		<?php endif; ?>
		<?php $header_image = get_header_image();
		if ( ! empty( $header_image ) ) : ?>
			<img src="<?php echo esc_url( $header_image ); ?>" alt="" />
		<?php endif; ?>
	</div>
<?php }
endif; // obox_admin_header_image