<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content-container">
 *
 * @package Minipress
 * @since Minipress 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/ie.css" type="text/javascript"></script>
<![endif]-->

<?php wp_head(); ?>

</head>

<body <?php body_class(''); ?>>

<div id="sitewrapper">
	<div id="header-container">
		<div id="header" class="clearfix">

			<div class="logo">
				<?php // Check to see if the header image has been removed
				$header_image = get_header_image();
				if ( ! empty( $header_image ) ) : ?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
						<img id="header-image" src="<?php header_image(); ?>" alt="<?php bloginfo(); ?>" />
					</a>
				<?php endif; ?>
				<?php if('blank' != get_theme_mod('header_textcolor') ) : ?>
					<h1>
						<a href="<?php echo home_url(); ?>">
							<?php echo strip_tags(bloginfo('name')); ?>
						</a>
					</h1>
				<?php endif; ?>
				<?php if( 'blank' != get_header_textcolor() && '' != get_bloginfo('description') ) : ?>
					<p class="tagline">
						<?php echo strip_tags(bloginfo('description')); ?>
					</p>
				<?php endif; ?>
			</div>

		</div><!--End header -->

	</div><!--End header-container -->

	<div id="navigation-container">
		<?php wp_nav_menu( array(
				'theme_location' => 'primary',
				'menu_id' => 'nav',
				'menu_class' => 'clearfix',
				'sort_column' => 'menu_order',
				'theme_location' => 'primary',
				'fallback_cb' => 'obox_menu_fallback',
				'container' => 'ul'
			) );
		?>
	</div>

<!--Begin Content -->
<div id="content-container" class="clearfix">
	<a href="#" id="menu-drop-button"></a>