<?php
/**
 * Template Name: Full Width
 * The Template for displaying a full width page
 *
 * @package Minipress
 * @since Minipress 1.0
 */
get_header(); ?>

<div id="full-width">
	<ul>
		<?php if ( have_posts() ) :
			while ( have_posts() ) : the_post();
				get_template_part( 'content' );
			endwhile; // end of the loop.
		else :
			// If there are no posts to display, show the content-empty template, which includes a search form
			get_template_part( 'content', 'empty' );
		endif; ?>
		<?php // If comments are open or we have at least one comment, load up the comment template
		if ( comments_open() || '0' != get_comments_number() ) :
			comments_template( '', true );
		endif; ?>
	</ul>
</div>

<?php get_footer(); ?>