<?php
/**
 * The Loop Part which displays listed post
 *
 * @package Minipress
 * @since Minipress 1.0
 */

// Check for a feature image
$image = get_the_post_thumbnail($post->ID, 500); ?>
<li id="post-<?php the_ID(); ?>" <?php post_class('post clearfix'); ?>>
	<div class="content clearfix">
		<?php if( 'quote' != get_post_format() ) : ?>

			<div class="post-title-block">
				<?php if( !is_page() ) { ?>
					<div class="top-meta">
						<h5 class="dater">
							<span><?php the_time('j M'); ?></span>
							<span><?php the_time('Y'); ?></span>
						</h5>
					</div>
				<?php } // !is_page() ?>
				<h2 class="post-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
				<?php if( !is_page() ) { ?>
					<h4 class="author-meta"><?php  obox_posted_on();  ?></h4>
				<?php } // !is_page() ?>
			</div>

			<!-- Show the Featured Image -->
			<?php if( '' !== $image) : ?>
				<div class="post-image"> <a href="<?php the_permalink(); ?>" rel="bookmark"><?php echo $image; ?></a> </div>
			<?php endif; ?>

			<!--Begin Excerpt -->
			<div class="copy">
				<?php the_content();
				wp_link_pages(); ?>
			</div>
			<?php // Build up the category and tag lists
				$categories_list = get_the_category_list( __( ', ', 'obox' ) );
				$tags_list = get_the_tag_list( '', __( ', ', 'obox' ) );
			?>
		<?php else : ?>

			<div class="copy">
				<?php the_content(); ?>
			</div>
			<cite>&mdash; <?php the_title(); ?></cite>

		<?php endif; ?>

	</div>
	<?php // Build up the category and tag lists
		$categories_list = get_the_category_list( __( ', ', 'obox' ) );
		$tags_list = get_the_tag_list( '', __( ', ', 'obox' ) );
	?>
	<div class="post-meta">
		<div class="post-comments">
			<a href="<?php comments_link(); ?>"><?php comments_number(__('0 Comments','obox'),__('1 Comment','obox'),__('% Comments','obox')); ?></a>
		</div>

		<?php if ( $categories_list && obox_categorized_blog() ) : ?>
			<div class="alignright">
				<?php printf( __( 'Posted in %1$s', 'obox' ), $categories_list ); ?>
			</div>
		<?php endif; // End if categories ?>

		<?php if ( $tags_list ) : ?>
			<div class="alignright">
				<?php printf( __( 'Tagged %1$s', 'obox' ), $tags_list ); ?>
			</div>
		<?php endif; // End if $tags_list ?>
	</div>
</li>