<?php
/**
 * The template for displaying Author Archive pages.
 *
 * @package Minipress
 * @since Minipress 1.0
 */
 get_header();
 	if ( have_posts() ) :
		// Make sure we know which author to query
		the_post(); ?>
			<h2 class="section-title-404"><?php obox_author_title(); ?></h2>
		<?php // Rewind the posts to get the list of author's posts
		rewind_posts();
	endif; ?>
	<ul class="double-cloumn clearfix">
		<li id="left-column">
			<ul class="blog-main-post-container">
				<?php if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						get_template_part( 'content', 'list' );
					endwhile; // end of the loop.
				else :
					// If there are no posts to display, show the content-empty template, which includes a search form
					get_template_part( 'content', 'empty' );
				endif; ?>
			</ul>
			<?php obox_content_nav("clearfix", "pagination clearfix"); ?>
		</li>
		<?php get_sidebar(); ?>
	</ul>

<?php get_footer();