<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Minipress
 * @since Minipress 1.0
 */
 get_header(); ?>

	<h2 class="section-title-404">
		<?php if ( is_category() ) :
			printf( __( 'Category: %s', 'obox' ), '<span>' . single_cat_title( '' , false) . '</span>' );
		elseif ( is_tag() ) :
			printf( __( 'Tag: %s', 'obox' ), '<span>' . single_tag_title( '' , false) . '</span>' );
		elseif ( is_day() ) :
			printf( __( 'Daily Archives: %s', 'obox' ), '<span>' . get_the_date() . '</span>' );
		elseif ( is_month() ) :
			printf( __( 'Monthly Archives: %s', 'obox' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );
		elseif ( is_year() ) :
			printf( __( 'Yearly Archives: %s', 'obox' ), '<span>' . get_the_date( 'Y' ) . '</span>' );
		elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
			_e( 'Asides', 'obox' );
		elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
			_e( 'Images', 'obox');
		elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
			_e( 'Videos', 'obox' );
		elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
			_e( 'Quotes', 'obox' );
		elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
			_e( 'Links', 'obox' );
		else :
			_e( 'Archives', 'obox' );
		endif; ?>
	</h2>

	<ul class="double-cloumn clearfix">
		<li id="left-column">
			<ul class="blog-main-post-container">
				<?php if ( have_posts() ) :
					while ( have_posts() ) : the_post();
						get_template_part( 'content', 'list' );
					endwhile; // end of the loop.
				else :
					// If there are no posts to display, show the content-empty template, which includes a search form
					get_template_part( 'content', 'empty' );
				endif; ?>
			</ul>
			<?php obox_content_nav("clearfix", "pagination clearfix"); ?>
		</li>
		<?php get_sidebar(); ?>
	</ul>

<?php get_footer(); ?>