<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<title><?php wp_title('&laquo;', true, 'right'); ?> <?php bloginfo('name'); ?></title>
<?php	if ( !is_home() ) : ?>
	<link rel="start" href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?> Home" />
<?php	endif; ?>
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<!--[if IE 6]>
<style type="text/css">
div#header .headerbox{
	width:1000px;
}
div#content {
	width:1000px;
}
#globalNavi ul li {
	width: 110px;
}
</style>
<![endif]-->
	<?php //comments_popup_script(); // off by default ?>
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="header">
	<?php $Mflat_options = get_option('Mflat_theme_options'); ?>
	<div class="headerbox">
		<p class="siteName">
			<?php if ($Mflat_options['logo_src']!='') { ?>
				<a class="logo_img" href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?>"><img src="<?php echo $Mflat_options['logo_src']; ?>" /></a>
			<?php } else { ?>
				<a href="<?php echo home_url(); ?>" id="logo" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a>
			<?php } ?>
		</p>
		<?php if ( !$Mflat_options['desc']) {?>
			<p class="description"><?php bloginfo('description'); ?></p>
		<?php } ?>
	</div>
	<div id="globalNavi">
		<div class="headerbox">
			<?php if ( function_exists('wp_nav_menu') ):?>
				<?php wp_nav_menu( array( 'show_home' => 'Home','container' => 'globalNavi', 'theme_location' => 'primary') ); ?>	
			<?php else: ?>
				<?php wp_page_menu( array( 'show_home' => 'Home', 'sort_column' => 'menu_order' ) ); ?>
			<?php endif; ?>
			<div class="searchbox"><?php get_search_form(); ?></div>
			<div class="rss"><a href="<?php bloginfo('rss2_url'); ?>" rel="alternate" type="application/rss+xml" target="_blank"   title="rss Feed"></a></div>
	    </div>
	</div>
<div class="topbox"></div>
</div>

