<?php
/**
 * @package WordPress
 * @subpackage Mflat
 */
add_action( 'after_setup_theme', 'Mflat_theme_init' );

 function Mflat_theme_init(){
 add_theme_support( 'automatic-feed-links' );
 if ( ! isset( $content_width ) ) $content_width = 640; 
load_theme_textdomain('Mflat', get_template_directory() . '/languages');

 // Theme uses wp_nav_menu() in one location.
register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'Mflat' ),
) );

//register sidebar
    register_sidebar( array(
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="widget-title">',
		'after_title' => '</span>',
	));
}
	
//custom comments
if (function_exists('wp_list_comments')) {

function Mflat_custom_comments($comment, $args, $depth) {
$GLOBALS['comment'] = $comment;
?>
<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
<span class="avatarx"><?php echo get_avatar($comment,$size='40',$default='<path_to_url>' ); ?></span>
<div class="message_head">
<span class="reply"><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></span>
<span class="name"><?php comment_author_link() ?></span>
<span class="date"><?php comment_date('y/m/d') ?></span>
<div class="cmt_text"><?php comment_text(); ?></div>
	</div>

<?php }}

/* Theme Options*/
function Mflat_theme_options(){
	$items = array (
		array(
			'id' => 'logo_src',
			'name' => __( 'Logo image', 'Mflat' ),
			'desc' => __('Put your logo image address here (max size: 280px*80px). If empty, display blog title with text.', 'Mflat')
		),
		array(
			'id' => 'desc',
			'name' => __('Disable the site description','Mflat'),
			'desc' => __('Disabling this will remove the site description.', 'Mflat')
		),
		array(
			'id' => 'arch_excerpt_check',
			'name' => __('Archive Excerpt?', 'Mflat'),
			'desc' => __('If the archive pages to display excerpt of post, check.', 'Mflat')
		),
		array(
			'id' => 'home_excerpt_check',
			'name' => __('Home Excerpt?', 'Mflat'),
			'desc' => __('If the home page to display excerpt of post, check.', 'Mflat')
		)
	);
	return $items;
}

add_action( 'admin_init', 'Mflat_theme_options_init' );
add_action( 'admin_menu', 'Mflat_theme_options_add_page' );
function Mflat_theme_options_init(){
	register_setting( 'Mflat_options', 'Mflat_theme_options', 'Mflat_options_validate' );
}
function Mflat_theme_options_add_page() {
	add_theme_page( __( 'Theme Options', 'Mflat' ), __( 'Theme Options', 'Mflat'), 'edit_theme_options', 'theme_options', 'Mflat_theme_options_do_page' );
}

function Mflat_default_options() {
	$Mflat_options = get_option( 'Mflat_theme_options' );
	foreach ( Mflat_theme_options() as $item ) {
		if ( ! isset( $Mflat_options[$item['id']] ) ) {
			$Mflat_options[$item['id']] = '';
		}
	}
	update_option( 'Mflat_theme_options', $Mflat_options );
}
add_action( 'init', 'Mflat_default_options' );

function Mflat_theme_options_do_page() {
	if ( ! isset( $_REQUEST['updated'] ) )
		$_REQUEST['updated'] = false;
?>
	<div class="wrap">
		<?php screen_icon(); echo "<h2>" . sprintf( __( '%1$s Theme Options', 'Mflat' ), get_current_theme() )	 . "</h2>"; ?>
		<?php if ( false !== $_REQUEST['updated'] ) : ?>
		<div class="updated fade"><p><strong><?php _e( 'Options saved', 'Mflat' ); ?></strong></p></div>
		<?php endif; ?>
		<form method="post" action="options.php">
			<?php settings_fields( 'Mflat_options' ); ?>
			<?php $Mflat_options = get_option( 'Mflat_theme_options' ); ?>
			<table class="form-table">
			<?php foreach (Mflat_theme_options() as $item) { ?>
				<?php if ($item['id'] == 'logo_src') { ?>
				<tr valign="top" style="margin:0 10px;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<input id="<?php echo 'Mflat_theme_options['.$item['id'].']'; ?>" name="<?php echo 'Mflat_theme_options['.$item['id'].']'; ?>" type="text" value="<?php if ( $Mflat_options[$item['id']] != "") { echo $Mflat_options[$item['id']]; } else { echo ''; } ?>" size="80" />
						<br/>
						<label class="description" for="<?php echo 'Mflat_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } else { ?>
				<tr valign="top" style="margin:0 10px;">
					<th scope="row"><?php echo $item['name']; ?></th>
					<td>
						<input id="<?php echo 'Mflat_theme_options['.$item['id'].']'; ?>" name="<?php echo 'Mflat_theme_options['.$item['id'].']'; ?>" type="checkbox" value="1" <?php checked($Mflat_options[$item['id']], 1); ?> />
						<label class="description" for="<?php echo 'Mflat_theme_options['.$item['id'].']'; ?>"><?php echo $item['desc']; ?></label>
					</td>
				</tr>
				<?php } ?>
			<?php } ?>
			</table>
				<?php submit_button( __( 'Save Options', 'Mflat' ), 'submit') ?>
		
		</form>
	</div>
<?php
}
function Mflat_options_validate($input) {
		// If the checkbox has not been checked, void it
		$input['logo_src'] = esc_url_raw($input['logo_src']);

		foreach ( array('desc', 'arch_excerpt_check', 'home_excerpt_check') as $key ) {
			$input[$key] = ($input[$key]) ? true : false;
		}		
	return $input;
}