jQuery(document).ready(function ($) {

    // Preloader
    jQuery('#preloader').delay(1500).fadeOut();
    jQuery('#loader').delay(1500).fadeOut("slow");

    // Scroll to Top Button
    if ($('.go-to-top').length) {
        var scrollTrigger = $('body').position(); // px
        var goToTop = function () {
            var scrollTop = $(window).scrollTop();
            if (scrollTop > 150) {
                $('.footer-go-to-top').addClass('show');
            } else {
                $('.footer-go-to-top').removeClass('show');
            }
        };
        goToTop();
        $(window).on('scroll', function () {
            goToTop();
        });
        $('.go-to-top').on('click', function (e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: scrollTrigger.top
            }, 700);
        });
    }

    // Mobile Menu Focus
    $(window).resize(massage_wellness_retreat_navTrapp);

    function massage_wellness_retreat_navTrapp() {
        var width = $(window).width();
        if (width < 992) {
            $('.main-navigation').on('keydown', function (e) {
                if ($('.main-navigation').hasClass('toggled')) {
                    var focusableEls = $('.main-navigation a[href]:not([disabled]), .main-navigation button');
                    var firstFocusableEl = focusableEls[0];
                    var lastFocusableEl = focusableEls[focusableEls.length - 1];
                    var KEYCODE_TAB = 9;
                    var KEYCODE_ESC = 27;
                    if (e.key === 'Tab' || e.keyCode === KEYCODE_TAB) {
                        if (e.shiftKey) { // shift + tab
                            if (document.activeElement === firstFocusableEl) {
                                lastFocusableEl.focus();
                                e.preventDefault();
                            }
                        } else { // tab
                            if (document.activeElement === lastFocusableEl) {
                                firstFocusableEl.focus();
                                e.preventDefault();
                            }
                        }
                    }
                    if (e.keyCode === KEYCODE_ESC) {
                        $('.main-navigation').removeClass('toggled');
                        return;
                    }
                }
            });
        }
    }

    massage_wellness_retreat_navTrapp();

    // Expert Carousel
    var owlExpert = jQuery('#main-expert-wrap .owl-carousel');
    owlExpert.owlCarousel({
        margin: 20,
        nav: false,
        autoplay: false,
        lazyLoad: false,
        autoplayTimeout: 2000,
        loop: true,
        dots: false,
        rtl: $('html').attr('dir') === 'rtl',  // Set RTL based on HTML direction
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 2
            },
            768: {
                items: 3
            },
            1000: {
                items: 4
            }
        },
        autoplayHoverPause: true,
        mouseDrag: true
    });

});

// slider js
document.addEventListener('DOMContentLoaded', function() {
  const slider = document.querySelector('#slider');
  if (!slider) return; // Stop if slider doesn't exist

  const slides = slider.querySelectorAll('.carousel-item');
  const indicators = slider.querySelectorAll('.indicator');
  const prevBtn = slider.querySelector('.arrow-up');
  const nextBtn = slider.querySelector('.arrow-down');
  let currentIndex = 0;

  function massage_wellness_retreat_showSlide(index) {
    slides.forEach(slide => slide.classList.remove('active'));
    indicators.forEach(ind => ind.classList.remove('active'));

    slides[index].classList.add('active');
    indicators[index].classList.add('active');
    currentIndex = index;
  }

  indicators.forEach((indicator, i) => {
    indicator.addEventListener('click', () => massage_wellness_retreat_showSlide(i));
  });

  if (prevBtn) {
    prevBtn.addEventListener('click', () => {
      let newIndex = (currentIndex - 1 + slides.length) % slides.length;
      massage_wellness_retreat_showSlide(newIndex);
    });
  }

  if (nextBtn) {
    nextBtn.addEventListener('click', () => {
      let newIndex = (currentIndex + 1) % slides.length;
      massage_wellness_retreat_showSlide(newIndex);
    });
  }
});