<?php
/**
 * Template Name: Home Page
 */
get_header();
?>

<main id="primary">

    <?php 
    $massage_wellness_retreat_number = get_theme_mod('massage_wellness_retreat_slide_number', '3');
    $massage_wellness_retreat_show_slider = get_theme_mod('massage_wellness_retreat_show_slider', 0);
    if ( $massage_wellness_retreat_number != '' && $massage_wellness_retreat_show_slider ) {
    ?>
    <section id="slider" class="mw-100 m-auto p-0">
        <div class="container-fuild">
            <!-- Main Slider -->
            <div class="carousel-inner" role="listbox">
            <?php for ( $massage_wellness_retreat_i = 1; $massage_wellness_retreat_i <= $massage_wellness_retreat_number; $massage_wellness_retreat_i++ ) { 
              $massage_wellness_retreat_slide_img = get_theme_mod('massage_wellness_retreat_banner_background_image_sec' . $massage_wellness_retreat_i);
              $massage_wellness_retreat_active_class = ($massage_wellness_retreat_i == 1) ? 'active' : '';
            ?>
              <div class="carousel-item <?php echo $massage_wellness_retreat_active_class; ?>" data-index="<?php echo $massage_wellness_retreat_i; ?>">
                <div class="carousel-caption">
                  <div class="inner_carousel">
                    <?php if ( get_theme_mod('massage_wellness_retreat_slider_top_title' . $massage_wellness_retreat_i) != '' ) { ?>
                      <p class="slide_top_text mb-4"><?php echo esc_html(get_theme_mod('massage_wellness_retreat_slider_top_title' . $massage_wellness_retreat_i)); ?></p>
                    <?php } ?>
                    <?php if ( get_theme_mod('massage_wellness_retreat_slider_title' . $massage_wellness_retreat_i) != '' ) { ?>
                      <h1 class="slide_title p-0 mb-2"><?php echo esc_html(get_theme_mod('massage_wellness_retreat_slider_title' . $massage_wellness_retreat_i)); ?></h1>
                    <?php } ?>
                    <?php if ( get_theme_mod('massage_wellness_retreat_slider_text' . $massage_wellness_retreat_i) != '' ) { ?>
                      <p class="slide_text mb-4"><?php echo esc_html(get_theme_mod('massage_wellness_retreat_slider_text' . $massage_wellness_retreat_i)); ?></p>
                    <?php } ?>
                    <div class="main-slider-button">
                        <?php if ( get_theme_mod('massage_wellness_retreat_slider_button1_link'.$massage_wellness_retreat_i) ||  get_theme_mod('massage_wellness_retreat_slider_button1_text'.$massage_wellness_retreat_i )) : ?><a class="btn-1" href="<?php echo esc_url( get_theme_mod('massage_wellness_retreat_slider_button1_link'.$massage_wellness_retreat_i) ); ?>"><?php echo esc_html( get_theme_mod('massage_wellness_retreat_slider_button1_text'.$massage_wellness_retreat_i) ); ?></a><?php endif; ?>
                    </div>
                  </div>
                </div>
                <div class="slider-carousel">
                  <div class="image-overlay"></div>
                  <?php if ( $massage_wellness_retreat_slide_img ) { ?>
                    <img class="slider-carousel-img" src="<?php echo esc_url($massage_wellness_retreat_slide_img); ?>" alt="<?php echo esc_attr(get_theme_mod('massage_wellness_retreat_slider_title' . $massage_wellness_retreat_i)); ?>">
                  <?php } else { ?>
                    <img class="slider-carousel-img" src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/default.jpg'); ?>" alt="Default Slide">
                  <?php } ?>
                </div>
              </div>
            <?php } ?>
            </div>
            <!-- Thumbnail Indicators -->
            <div class="slider-indicator text-center">
            <?php for ( $massage_wellness_retreat_i = 1; $massage_wellness_retreat_i <= $massage_wellness_retreat_number; $massage_wellness_retreat_i++ ) { 
              $massage_wellness_retreat_thumb_img = get_theme_mod('massage_wellness_retreat_banner_background_image_sec' . $massage_wellness_retreat_i);
              $massage_wellness_retreat_active_class = ($massage_wellness_retreat_i == 1) ? 'active' : '';
            ?>
              <button class="indicator <?php echo $massage_wellness_retreat_active_class; ?>" data-index="<?php echo $massage_wellness_retreat_i; ?>">
                <?php if ( $massage_wellness_retreat_thumb_img ) { ?>
                  <img src="<?php echo esc_url($massage_wellness_retreat_thumb_img); ?>" alt="Thumbnail">
                <?php } else { ?>
                  <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/default-thumb.jpg'); ?>" alt="Default Thumbnail">
                <?php } ?>
              </button>
            <?php } ?>
            </div>
            <!-- Arrow Controls -->
            <!-- Arrow Controls -->
            <button class="arrow arrow-up" aria-label="<?php esc_attr_e('Previous Slide', 'massage-therapy'); ?>">&#9650;</button>
            <button class="arrow arrow-down" aria-label="<?php esc_attr_e('Next Slide', 'massage-therapy'); ?>">&#9660;</button>
        </div>
    </section>
    <?php } ?>

   <?php 
    $massage_wellness_retreat_main_expert_wrap = absint(get_theme_mod('massage_wellness_retreat_enable_event', 0));
    if($massage_wellness_retreat_main_expert_wrap == 1): 
        $massage_wellness_retreat_catData2 = get_theme_mod('massage_wellness_retreat_blog_cat','uncategorized');

        if(!empty($massage_wellness_retreat_catData2) && $massage_wellness_retreat_catData2 !== 'select'): 
            $massage_wellness_retreat_page_query = new WP_Query(array( 
                'category_name' => esc_html($massage_wellness_retreat_catData2),
                'posts_per_page' => -1  // Fetch all posts from the category
            ));

            if($massage_wellness_retreat_page_query->have_posts()): ?>
                <section id="main-expert-wrap">
                    <div class="container">
                        <div class="heading-expert-wrap">
                            <?php if ($massage_wellness_retreat_event_text = get_theme_mod('massage_wellness_retreat_event_text')): ?>
                                <h2><?php echo esc_html($massage_wellness_retreat_event_text); ?></h2>
                            <?php endif; ?>
                        </div>
                        <div id="primary">
                            <div class="owl-carousel">
                                <?php while($massage_wellness_retreat_page_query->have_posts()): $massage_wellness_retreat_page_query->the_post(); ?>
                                    <div class="box">
                                        <div class="box-image">
                                            <?php if ( has_post_thumbnail() ) { 
                                                the_post_thumbnail(); 
                                            } else { ?>
                                                <img src="<?php echo esc_url( get_template_directory_uri() . '/revolution/assets/images/post-img.png' ); ?>" alt="<?php the_title_attribute(); ?>">
                                            <?php } ?>
                                        </div>

                                        <div class="box-content">
                                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                            <p class="post-content"><?php echo wp_trim_words(get_the_content(), 15); ?></p>
                                        </div>
                                        <div class="clearfix"></div> 
                                    </div>          
                                <?php endwhile; wp_reset_postdata(); ?>
                            </div>
                        </div>                
                    </div>
                </section>
            <?php else: ?>
                <p><?php esc_html_e('No posts found in this category.', 'massage-therapy'); ?></p>
            <?php endif; 
        endif; 
    endif; 
    ?> 
</main>
<?php
get_footer();
?>