<?php
/**
 * The header for our theme
 *
 * @package Massage Therapy
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'massage-therapy' ); ?></a>
    <?php
    $massage_wellness_retreat_preloader_wrap = absint(get_theme_mod('massage_wellness_retreat_enable_preloader', 0));
    if ($massage_wellness_retreat_preloader_wrap === 1): ?>
        <div id="loader">
            <div class="loader-container">
                <div id="preloader" class="loader-2">
                    <div class="dot"></div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <header id="masthead" class="site-header">
        <?php if (get_theme_mod('massage_wellness_retreat_show_topbar', 1)) : ?>
            <div class="top-head">
                <div class="container-fuild">
                    <?php if (get_theme_mod('massage_wellness_retreat_top_head_text') !== '') : ?>
                      <p><?php echo esc_html(get_theme_mod('massage_wellness_retreat_top_head_text', 'Relax, rejuvenate, and restore — enjoy exclusive massage deals this week only!')); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php $massage_wellness_retreat_has_header_image = has_header_image();

        if ($massage_wellness_retreat_has_header_image) {
            $massage_wellness_retreat_header_image_url = esc_url(get_header_image());
        } else {
            $massage_wellness_retreat_header_image_url = '';
        }
        ?>
        <div class="header-menu-box <?php echo esc_attr( get_theme_mod( 'massage_wellness_retreat_enable_sticky_header', false ) ? 'sticky-header' : '' ); ?>" style="background-image: url('<?php echo $massage_wellness_retreat_header_image_url; ?>');">
            <div class="container-fuild">
                <div class="flex-row">
                    <div class="nav-menu-header-left">
                        <div class="site-branding">
                            <?php
                            the_custom_logo();
                            if (is_front_page() && is_home()):
                                if (get_theme_mod('massage_wellness_retreat_site_title_text', true)): ?>
                                    <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <?php endif;
                            else:
                                if (get_theme_mod('massage_wellness_retreat_site_title_text', true)): ?>
                                    <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></p>
                                <?php endif;
                            endif;

                            $massage_wellness_retreat_description = get_bloginfo('description', 'display');
                            if ($massage_wellness_retreat_description || is_customize_preview()):
                                if (get_theme_mod('massage_wellness_retreat_site_tagline_text', false)): ?>
                                    <p class="site-description"><?php echo esc_html($massage_wellness_retreat_description); ?></p>
                                <?php endif;
                            endif; ?>
                        </div>
                    </div>
                    <div class="nav-menu-header-center">
                        <nav id="site-navigation" class="main-navigation">
                            <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                <span class="screen-reader-text"><?php esc_html_e('Primary Menu', 'massage-therapy'); ?></span>
                                <i class="fas fa-bars"></i>
                            </button>
                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'menu-1',
                                'menu_id'        => 'primary-menu',
                            ));
                            ?>
                        </nav>
                        <div class="search-block">
                          <?php 
                            get_search_form();
                          ?>
                        </div>
                         <div class="header-details">
                            <?php
                            // Get the link from the Customizer
                            $massage_wellness_retreat_product_btn_link1 = get_theme_mod( 'massage_wellness_retreat_product_section_btn_link1','#' );

                            // Only show the icon if the link is not empty
                            if ( ! empty( $massage_wellness_retreat_product_btn_link1 ) ) : ?>
                                <a class="viewall-btn mb-3" href="<?php echo esc_url( $massage_wellness_retreat_product_btn_link1 ); ?>" aria-label="<?php echo esc_attr__( 'user', 'massage-therapy' ); ?>">
                                    <i class="fas fa-user"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
</div>