<?php

// Enqueue parent and child styles
function massage_therapy_child_enqueue_styles() {

    // 1. Load parent theme CSS
    wp_enqueue_style(
        'massage-wellness-retreat-style', // Parent handle
        get_template_directory_uri() . '/style.css',
        array(),
        MASSAGE_WELLNESS_RETREAT_VERSION
    );

    // 2. Load child theme CSS (depends on parent)
    wp_enqueue_style(
        'massage-wellness-retreat-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('massage-wellness-retreat-style'),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'massage_therapy_child_enqueue_styles' );

// Enqueue child theme JS in addition to parent JS
function massage_therapy_child_scripts() {

    // Load child custom JS
    wp_enqueue_script(
        'massage-wellness-retreat-child-js',
        get_stylesheet_directory_uri() . '/revolution/assets/js/custom.js', // <-- your file in child theme
        array('jquery'), // load after jQuery
        wp_get_theme()->get('Version'),
        true
    );
}
add_action( 'wp_enqueue_scripts', 'massage_therapy_child_scripts' );

// Theme setup
if (!function_exists('massage_therapy_setup')) :
    function massage_therapy_setup() {
        load_theme_textdomain( 'massage-therapy', get_template_directory() . '/languages' );
        add_theme_support('automatic-feed-links');
        add_theme_support('title-tag');
        add_theme_support('custom-header');
        add_theme_support('responsive-embeds');
        add_theme_support('post-thumbnails');
        add_theme_support('align-wide');
        add_editor_style(array('assets/css/editor-style.css'));
        add_theme_support('custom-background', apply_filters('massage_therapy_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));
        if ( ! defined( 'MASSAGE_WELLNESS_RETREAT_IMPORT_URL' ) ) {
            define( 'MASSAGE_WELLNESS_RETREAT_IMPORT_URL', esc_url( admin_url( 'themes.php?page=massagetherapy-demoimport' ) ) );
        }
        if ( ! defined( 'MASSAGE_WELLNESS_RETREAT_WELCOME_MESSAGE' ) ) {
            define( 'MASSAGE_WELLNESS_RETREAT_WELCOME_MESSAGE', __( 'Welcome to Massage Therapy', 'massage-therapy' ) );
        }
    }
endif;
add_action('after_setup_theme', 'massage_therapy_setup');

// Set content width
function massage_therapy_content_width() {
    $GLOBALS['content_width'] = apply_filters('massage_therapy_content_width', 1170);
}
add_action('after_setup_theme', 'massage_therapy_content_width', 0);

// Register widget areas
function massage_therapy_widgets_init() {
    register_sidebar(array(
        'name' => __('Sidebar Widget Area', 'massage-therapy'),
        'id' => 'massage-wellness-retreat-sidebar-primary',
        'description' => __('The Primary Widget Area', 'massage-therapy'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4><div class="title"><span class="shap"></span></div>',
    ));
    register_sidebar(array(
        'name' => __('Footer Widget Area', 'massage-therapy'),
        'id' => 'massage-wellness-retreat-footer-widget-area',
        'description' => __('The Footer Widget Area', 'massage-therapy'),
        'before_widget' => '<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.2s"><aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside></div>',
        'before_title' => '<h5 class="widget-title w-title">',
        'after_title' => '</h5><span class="shap"></span>',
    ));
}
add_action('widgets_init', 'massage_therapy_widgets_init');

// Remove customizer settings
function massage_therapy_remove_custom($wp_customize) {

    $wp_customize->remove_setting('massage_wellness_retreat_primary_color');
    $wp_customize->remove_control('massage_wellness_retreat_primary_color');

}
add_action('customize_register', 'massage_therapy_remove_custom', 1000);

function massage_therapy_child_customize_register( $wp_customize ) {

    $wp_customize->add_setting( 'massage_therapy_primary_color',
        array(
        'default'           => '#136B32',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
        $wp_customize, 
        'massage_therapy_primary_color',
        array(
            'label'      => esc_html__( 'Primary Color', 'massage-therapy' ),
            'section'    => 'massage_wellness_retreat_global_color_section',
            'settings'   => 'massage_therapy_primary_color',
        ) ) 
    );

}
add_action( 'customize_register', 'massage_therapy_child_customize_register', 20 );

// Global colors
function massage_therapy_dynamic_colors() {
    $massage_therapy_primary_color = get_theme_mod('massage_therapy_primary_color', '#136B32');

    $massage_therapy_custom_css = ':root {';
    $massage_therapy_custom_css .= '--primary-color: ' . esc_attr( $massage_therapy_primary_color ) . ';';
    $massage_therapy_custom_css .= '}';

    echo '<style type="text/css">' . $massage_therapy_custom_css . '</style>';
}
add_action('wp_head', 'massage_therapy_dynamic_colors');
