<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'lalita_background_setup' );
function lalita_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => 'ff6e00',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Overwrite theme URL
function lalita_theme_uri_link() {
	return 'https://wpkoi.com/makara-wpkoi-wordpress-theme/';
}

// Overwrite parent theme's blog header function
add_action( 'lalita_after_header', 'lalita_blog_header_image', 11 );
function lalita_blog_header_image() {

	if ( ( is_front_page() && is_home() ) || ( is_home() ) ) { 
		$blog_header_image 			=  lalita_get_setting( 'blog_header_image' ); 
		$blog_header_title 			=  lalita_get_setting( 'blog_header_title' ); 
		$blog_header_text 			=  lalita_get_setting( 'blog_header_text' ); 
		$blog_header_button_text 	=  lalita_get_setting( 'blog_header_button_text' ); 
		$blog_header_button_url 	=  lalita_get_setting( 'blog_header_button_url' ); 
		if ( $blog_header_image != '' ) { ?>
		<div class="page-header-image grid-parent page-header-blog" style="background-image: url('<?php echo esc_url($blog_header_image); ?>') !important;">
        	<div class="page-header-noiseoverlay"></div>
        	<div class="page-header-blog-inner">
                <div class="page-header-blog-content-h grid-container">
                    <div class="page-header-blog-content">
                    <?php if ( $blog_header_title != '' ) { ?>
                        <div class="page-header-blog-text">
                            <?php if ( $blog_header_title != '' ) { ?>
                            <h2><?php echo wp_kses_post( $blog_header_title ); ?></h2>
                            <div class="clearfix"></div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                    </div>
                </div>
                <div class="page-header-blog-content page-header-blog-content-b">
                	<?php if ( $blog_header_text != '' ) { ?>
                	<div class="page-header-blog-text">
						<?php if ( $blog_header_title != '' ) { ?>
                        <p><?php echo wp_kses_post( $blog_header_text ); ?></p>
                        <div class="clearfix"></div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="page-header-blog-button">
                        <?php if ( $blog_header_button_text != '' ) { ?>
                        <a class="read-more button" href="<?php echo esc_url( $blog_header_button_url ); ?>"><?php echo esc_html( $blog_header_button_text ); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</div>
		<?php
		}
	}
}

// Extra cutomizer functions
if ( ! function_exists( 'makara_customize_register' ) ) {
	add_action( 'customize_register', 'makara_customize_register' );
	function makara_customize_register( $wp_customize ) {
				
		// Add Makara customizer section
		$wp_customize->add_section(
			'makara_layout_effects',
			array(
				'title' => __( 'Makara Effects', 'makara' ),
				'priority' => 24,
			)
		);
		
		// Blog image effect
		$wp_customize->add_setting(
			'makara_settings[img_effect]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'makara_settings[img_effect]',
			array(
				'type' => 'select',
				'label' => __( 'Blog image effect', 'makara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'makara' ),
					'disable' => __( 'Disable', 'makara' )
				),
				'settings' => 'makara_settings[img_effect]',
				'section' => 'makara_layout_effects',
				'priority' => 10
			)
		);
		
		// Sidebar border
		$wp_customize->add_setting(
			'makara_settings[sidebar_border]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'makara_settings[sidebar_border]',
			array(
				'type' => 'select',
				'label' => __( 'Sidebar border', 'makara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'makara' ),
					'disable' => __( 'Disable', 'makara' )
				),
				'settings' => 'makara_settings[sidebar_border]',
				'section' => 'makara_layout_effects',
				'priority' => 20
			)
		);
		
		// Unique scrollbar
		$wp_customize->add_setting(
			'makara_settings[unique_scrollbar]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'makara_settings[unique_scrollbar]',
			array(
				'type' => 'select',
				'label' => __( 'Unique scrollbar', 'makara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'makara' ),
					'disable' => __( 'Disable', 'makara' )
				),
				'settings' => 'makara_settings[unique_scrollbar]',
				'section' => 'makara_layout_effects',
				'priority' => 30
			)
		);
		
		// Makara button
		$wp_customize->add_setting(
			'makara_settings[makara_button]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'makara_settings[makara_button]',
			array(
				'type' => 'select',
				'label' => __( 'Makara button', 'makara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'makara' ),
					'disable' => __( 'Disable', 'makara' )
				),
				'settings' => 'makara_settings[makara_button]',
				'section' => 'makara_layout_effects',
				'priority' => 40
			)
		);
		
		// Makara effect colors
		$wp_customize->add_setting(
			'makara_settings[makara_color_1]', array(
				'default' => '#ff6e00',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'makara_settings[makara_color_1]',
				array(
					'label' => __( 'Effect color', 'makara' ),
					'section' => 'makara_layout_effects',
					'settings' => 'makara_settings[makara_color_1]',
					'priority' => 45
				)
			)
		);
		
		$wp_customize->add_setting(
			'makara_settings[makara_color_2]', array(
				'default' => '#ffffff',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'makara_settings[makara_color_2]',
				array(
					'label' => __( 'Effect color 2', 'makara' ),
					'section' => 'makara_layout_effects',
					'settings' => 'makara_settings[makara_color_2]',
					'priority' => 46
				)
			)
		);
		
		$wp_customize->add_setting(
			'makara_settings[makara_color_3]', array(
				'default' => '#000000',
				'type' => 'option',
				'sanitize_callback' => 'makara_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'makara_settings[makara_color_3]',
				array(
					'label' => __( 'Effect color 3', 'makara' ),
					'section' => 'makara_layout_effects',
					'settings' => 'makara_settings[makara_color_3]',
					'priority' => 47
				)
			)
		);
	}
}

//Sanitize choices.
if ( ! function_exists( 'makara_sanitize_choices' ) ) {
	function makara_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// Sanitize colors. Allow blank value.
if ( ! function_exists( 'makara_sanitize_hex_color' ) ) {
	function makara_sanitize_hex_color( $color ) {
	    if ( '' === $color ) {
	        return '';
		}

	    // 3 or 6 hex digits, or the empty string.
	    if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
	        return $color;
		}

	    return '';
	}
}

// Makara effects colors css
if ( ! function_exists( 'makara_effect_colors_css' ) ) {
	function makara_effect_colors_css() {
		// Get Customizer settings
		$makara_settings = get_option( 'makara_settings' );
		
		$makara_color_1  	 = '#ff6e00';
		$makara_color_2  	 = '#ffffff';
		$makara_color_3  	 = '#000000';
		if ( isset( $makara_settings['makara_color_1'] ) ) {
			$makara_color_1 = $makara_settings['makara_color_1'];
		}
		if ( isset( $makara_settings['makara_color_2'] ) ) {
			$makara_color_2 = $makara_settings['makara_color_2'];
		}
		if ( isset( $makara_settings['makara_color_3'] ) ) {
			$makara_color_3 = $makara_settings['makara_color_3'];
		}
		
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_color_defaults()
		);
		
		$makara_extracolors = '.makara-button .button,.makara-button .button:visited,.makara-button button:not(.menu-toggle),
html .makara-button input[type="button"],.makara-button input[type="reset"],.makara-button input[type="submit"],.woocommerce.makara-button a.button, .woocommerce.makara-button button.button.alt {color: ' . esc_attr( $makara_color_2 ) . '; border-color: ' . esc_attr( $makara_color_3 ) . '}.makara-button .button:hover,.makara-button .button:visited:hover,.makara-button button:not(.menu-toggle):hover,
html .makara-button input[type="button"]:hover,.makara-button input[type="reset"]:hover,.makara-button input[type="submit"]:hover,.woocommerce.makara-button a.button:hover, .woocommerce.makara-button button.button.alt:hover {color: ' . esc_attr( $makara_color_3 ) . ';border-color: ' . esc_attr( $makara_color_2 ) . ';background-color: ' . esc_attr( $makara_color_2 ) . '}.makara-sidebar-border #right-sidebar, .makara-sidebar-border #left-sidebar{border-color: ' . esc_attr( $makara_color_3 ) . ';}.makara-unique-scrollbar::-webkit-scrollbar-track {background: ' . esc_attr( $makara_color_3 ) . ';}.makara-unique-scrollbar::-webkit-scrollbar-thumb {background: ' . esc_attr( $makara_color_1 ) . ';border-color: ' . esc_attr( $makara_color_3 ) . ';}.makara-unique-scrollbar::-webkit-scrollbar-thumb:hover {background: ' . esc_attr( $makara_color_2 ) . ';}';
		
		return $makara_extracolors;
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'makara_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'makara_remove_parent_dynamic_css' );
	function makara_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'lalita_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'makara_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'makara_enqueue_parent_dynamic_css', 50 );
	function makara_enqueue_parent_dynamic_css() {
		$css = lalita_base_css() . lalita_font_css() . lalita_advanced_css() . lalita_spacing_css() . lalita_no_cache_dynamic_css() .makara_effect_colors_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'lalita-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'makara_body_classes' ) ) {
	add_filter( 'body_class', 'makara_body_classes' );
	function makara_body_classes( $classes ) {
		// Get Customizer settings
		$makara_settings = get_option( 'makara_settings' );
		
		$img_effect 	  = 'enable';
		$makara_button  	  = 'enable';
		$sidebar_border  = 'enable';
		$unique_scrollbar     = 'enable';
		
		if ( isset( $makara_settings['img_effect'] ) ) {
			$img_effect = $makara_settings['img_effect'];
		}
		
		if ( isset( $makara_settings['makara_button'] ) ) {
			$makara_button = $makara_settings['makara_button'];
		}
		
		if ( isset( $makara_settings['sidebar_border'] ) ) {
			$sidebar_border = $makara_settings['sidebar_border'];
		}
		
		if ( isset( $makara_settings['unique_scrollbar'] ) ) {
			$unique_scrollbar = $makara_settings['unique_scrollbar'];
		}
		
		// Blog image effect
		if ( $img_effect != 'disable' ) {
			$classes[] = 'makara-img-effect';
		}
		
		// Makara button
		if ( $makara_button != 'disable' ) {
			$classes[] = 'makara-button';
		}
		
		// Sidebar border
		if ( $sidebar_border != 'disable' ) {
			$classes[] = 'makara-sidebar-border';
		}
		
		// Unique scrollbar
		if ( $unique_scrollbar != 'disable' ) {
			$classes[] = 'makara-unique-scrollbar';
		}
		
		return $classes;
	}
}
